/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_services;

import ir.map.sdk_common.MapirLatLng;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class MapUtils {
    public static double wrap(double d2, double d3, double d4) {
        if (!(d2 >= d3) || !(d2 < d4)) {
            d2 = MapUtils.mod(d2 - d3, d4 - d3) + d3;
        }
        return d2;
    }

    static double mod(double d2, double d3) {
        return (d2 % d3 + d3) % d3;
    }

    public static boolean containsLocation(MapirLatLng mapirLatLng, List<MapirLatLng> list, boolean bl) {
        return MapUtils.containsLocation(mapirLatLng.latitude, mapirLatLng.longitude, list, bl);
    }

    public static boolean containsLocation(double d2, double d3, List<MapirLatLng> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return false;
        }
        List<MapirLatLng> list2 = list;
        d2 = Math.toRadians(d2);
        d3 = Math.toRadians(d3);
        MapirLatLng mapirLatLng = list2.get(n2 - 1);
        double d4 = Math.toRadians(mapirLatLng.latitude);
        double d5 = Math.toRadians(mapirLatLng.longitude);
        int n3 = 0;
        for (MapirLatLng mapirLatLng2 : list2) {
            double d6;
            double d7 = MapUtils.wrap(d3 - d5, -Math.PI, Math.PI);
            if (d2 == d4 && d7 == 0.0) {
                return true;
            }
            if (MapUtils.intersects(d4, d4 = Math.toRadians(mapirLatLng2.latitude), MapUtils.wrap((d6 = Math.toRadians(mapirLatLng2.longitude)) - d5, -Math.PI, Math.PI), d2, d7, bl)) {
                ++n3;
            }
            d5 = d6;
        }
        return n3 & true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean intersects(double d2, double d3, double d4, double d5, double d6, boolean bl) {
        if (!(d6 < 0.0)) {
            if (!(d6 < d4)) return false;
        }
        if (!(d6 >= 0.0)) {
            if (!(d6 >= d4)) return false;
        }
        if (d5 <= -1.5707963267948966) {
            return false;
        }
        if (!(d2 > -1.5707963267948966)) return false;
        if (!(d3 > -1.5707963267948966)) return false;
        if (!(d2 < 1.5707963267948966)) return false;
        if (!(d3 < 1.5707963267948966)) return false;
        if (d4 <= -Math.PI) {
            return false;
        }
        double d7 = d2;
        double d8 = (d7 * (d4 - d6) + d3 * d6) / d4;
        if (d7 >= 0.0 && d3 >= 0.0 && d5 < d8) {
            return false;
        }
        if (d2 <= 0.0 && d3 <= 0.0 && d5 >= d8 || d5 >= 1.5707963267948966) {
            return true;
        }
        if (bl) {
            if (!(Math.tan(d5) >= MapUtils.tanLatGC(d2, d3, d4, d6))) return false;
            return true;
        }
        if (!(MapUtils.mercator(d5) >= MapUtils.mercatorLatRhumb(d2, d3, d4, d6))) return false;
        return true;
    }

    private static double tanLatGC(double d2, double d3, double d4, double d5) {
        return (Math.tan(d2) * Math.sin(d4 - d5) + Math.tan(d3) * Math.sin(d5)) / Math.sin(d4);
    }

    static double mercator(double d2) {
        return Math.log(Math.tan(d2 * 0.5 + 0.7853981633974483));
    }

    private static double mercatorLatRhumb(double d2, double d3, double d4, double d5) {
        return (MapUtils.mercator(d2) * (d4 - d5) + MapUtils.mercator(d3) * d5) / d4;
    }

    private ArrayList<MapirLatLng> getMapPoses(String string) {
        ArrayList arrayList;
        MapUtils mapUtils = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        if ((string = mapUtils.loadJSONFromAsset(string)) != null) {
            int n2;
            JSONArray jSONArray;
            try {
                JSONArray jSONArray2;
                jSONArray = jSONArray2;
                jSONArray2 = new JSONArray(string);
                n2 = 0;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            while (true) {
                MapirLatLng mapirLatLng;
                if (n2 >= jSONArray.length()) break;
                ArrayList arrayList3 = arrayList2;
                MapirLatLng mapirLatLng2 = mapirLatLng;
                MapirLatLng mapirLatLng3 = mapirLatLng;
                JSONArray jSONArray3 = jSONArray.getJSONArray(n2);
                double d2 = jSONArray3.getDouble(1);
                JSONArray jSONArray4 = jSONArray.getJSONArray(n2);
                mapirLatLng2(d2, jSONArray4.getDouble(0));
                arrayList3.add(mapirLatLng3);
                ++n2;
                continue;
                break;
            }
        }
        return arrayList2;
    }

    /*
     * Exception decompiling
     */
    private String loadJSONFromAsset(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 33[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ArrayList<MapirLatLng> getEvenOddPoses() {
        return this.getMapPoses("even-odd");
    }

    public ArrayList<MapirLatLng> getTrafficPoses() {
        return this.getMapPoses("traffic");
    }
}

