package ir.map.sdk_services.network;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;

import org.json.JSONArray;
import org.json.JSONException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import ir.map.sdk_common.MapirLatLng;
import ir.map.sdk_services.MapUtils;
import ir.map.sdk_services.PublicTransportMode;
import ir.map.sdk_services.R;
import ir.map.sdk_services.RouteMode;
import ir.map.sdk_services.ServiceSDK;
import ir.map.sdk_services.URLHelper;
import ir.map.sdk_services.models.MapirAuthenticateResponse;
import ir.map.sdk_services.models.MapirBookmark;
import ir.map.sdk_services.models.MapirForgotEntity;
import ir.map.sdk_services.models.MapirLoginResponse;
import ir.map.sdk_services.models.MapirMedia;
import ir.map.sdk_services.models.MapirNetworkEntity;
import ir.map.sdk_services.models.MapirProfileResponse;
import ir.map.sdk_services.models.MapirPublicTransportResponse;
import ir.map.sdk_services.models.MapirResendVerification;
import ir.map.sdk_services.models.MapirReverse;
import ir.map.sdk_services.models.MapirRouteResponse;
import ir.map.sdk_services.models.MapirSearchPostCode;
import ir.map.sdk_services.models.MapirSearchResponse;
import ir.map.sdk_services.models.MapirSimpleNetworkEntity;
import ir.map.sdk_services.models.MapirTag;
import ir.map.sdk_services.models.MapirTicket;
import ir.map.sdk_services.models.MapirWeatherItem;
import okhttp3.RequestBody;
import rx.Observable;
import rx.Subscriber;

import static ir.map.sdk_services.URLHelper.FORGOT_PASSWORD_URL;
import static ir.map.sdk_services.URLHelper.GET_PROFILE;
import static ir.map.sdk_services.URLHelper.LOCAL_URL_GMAIL_LOGIN;
import static ir.map.sdk_services.URLHelper.SIGN_IN_OUT_URL;
import static ir.map.sdk_services.URLHelper.SIGN_UP_URL;
import static ir.map.sdk_services.URLHelper.STATIC_MAP;
import static ir.map.sdk_services.URLHelper.UPDATE_PROFILE;
import static ir.map.sdk_services.URLHelper.VERIFICATION_CODE_URL;

/**
 * @author Haniyeh Khaksar
 */

public class RestApiImpl implements RestApi {

    //    private PreferenceService preferenceService;
//    private  ;
    private Gson gsonMapper;

    public RestApiImpl() {
        gsonMapper = new Gson();
    }

    @Override
    public Observable<MapirReverse> getReverseGeoInfo(final String params) {

      return Observable.create(new Observable.OnSubscribe<MapirReverse>() {
            @Override
            public void call(Subscriber<? super MapirReverse> subscriber) {
                try {

                    String responseString = getReverseGeoInfoApi(params);

                    if (params == null || "" == params) {
                        subscriber.onError(new Throwable("Post Method Need Param"));
                    } else if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirReverse reverseGeoInfo = gsonMapper.fromJson(responseString, MapirReverse.class);
                        subscriber.onNext(reverseGeoInfo);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });

    }

    private String getReverseGeoInfoApi(String params) throws Exception {
        return ApiConnection.createGET(new String(URLHelper.MAP_REVERSE_GEO_URL) + params).call();
    }

//    @Override
//    public Observable<List<MapirSearch>> getPointOfInterests() {
//        return Observable.create(new Observable.OnSubscribe<List<MapirSearch>>() {
//            @Override
//            public void call(Subscriber<? super List<MapirSearch>> subscriber) {
//                try {
//                    InputStream is = context.getAssets().open("poi.json");
//                    int size = is.available();
//                    byte[] buffer = new byte[size];
//                    is.read(buffer);
//                    is.close();
//                    String responseString = new String(buffer);
//
//                    if (responseString == null) {
//                        subscriber.onError(new Throwable("Error From Server"));
//                    } else {
//
//
//                        maptexSearchList odataModel = gsonMapper.fromJson(responseString, maptexSearchList.class);
//
//                        subscriber.onNext(odataModel.getValues());
//                        subscriber.onCompleted();
//                    }
//
//                } catch (Exception e) {
//                    subscriber.onError(new Throwable("Error From Server"));
//
//                }
//            }
//        });
//    }

    @Override
    public Observable<MapirSimpleNetworkEntity> sendTicket(final String token, final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirSimpleNetworkEntity>() {
            @Override
            public void call(Subscriber<? super MapirSimpleNetworkEntity> subscriber) {
                try {

                    String responseString = sendTicketApi(token, params);

                    if (params == null || "" == params) {
                        subscriber.onError(new Throwable("Post Method Need Param"));
                    } else if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirSimpleNetworkEntity ticket = gsonMapper.fromJson(responseString, MapirSimpleNetworkEntity.class);
                        subscriber.onNext(ticket);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String sendTicketApi(String token, String params) throws Exception {
        return ApiConnection.createPOST(new String(URLHelper.MAP_CREATE_TICKET_URL), params, token).call();
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> sendReportTicket(final String token, final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirSimpleNetworkEntity>() {
            @Override
            public void call(Subscriber<? super MapirSimpleNetworkEntity> subscriber) {
                try {

                    String responseString = sendReportTicketApi(token, params);

                    if (params == null || "" == params) {
                        subscriber.onError(new Throwable("Post Method Need Param"));
                    } else if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirSimpleNetworkEntity ticket = gsonMapper.fromJson(responseString, MapirSimpleNetworkEntity.class);
                        subscriber.onNext(ticket);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String sendReportTicketApi(String token, String params) throws Exception {
        return ApiConnection.createPOST(new String(URLHelper.MAP_CREATE_REPORT_TICKET_URL), params, token).call();
    }

    @Override
    public Observable<List<MapirTicket>> getTicketList(final String token) {
      return Observable.create(new Observable.OnSubscribe<List<MapirTicket>>() {
            @Override
            public void call(Subscriber<? super List<MapirTicket>> subscriber) {
                try {

                    String responseString = getTicketListApi(token);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      List<MapirTicket> ticketList = gsonMapper.fromJson(responseString, new TypeToken<List<MapirTicket>>() {
                        }.getType());
                        subscriber.onNext(ticketList);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String getTicketListApi(String token) throws Exception {
        return ApiConnection.createGET(new String(URLHelper.MAP_TICKET_URL), token).call();
    }

    @Override
    public Observable<MapirMedia> uploadMediaByPath(final String token, final String path) {
      return Observable.create(new Observable.OnSubscribe<MapirMedia>() {
            @Override
            public void call(Subscriber<? super MapirMedia> subscriber) {
                try {

                    String responseString = uploadMediaByPathApi(token, path);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirMedia entity = gsonMapper.fromJson(responseString, MapirMedia.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String uploadMediaByPathApi(String token, String path) throws Exception {

        return ApiConnection.createPOST(new String(URLHelper.UPLOAD_MEDIA_URL), new File(path), token).call();
    }

    @Override
    public Observable<MapirWeatherItem> getWeatherInfo(final String path) {
      return Observable.create(new Observable.OnSubscribe<MapirWeatherItem>() {
            @Override
            public void call(Subscriber<? super MapirWeatherItem> subscriber) {
                try {

                    String responseString = getWeatherInfoApi(path);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirWeatherItem entity = gsonMapper.fromJson(responseString, MapirWeatherItem.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);
                }
            }
        });
    }

    @Override
    public Observable<List<MapirWeatherItem>> getAllWeatherInfo() {
      return Observable.create(new Observable.OnSubscribe<List<MapirWeatherItem>>() {
            @Override
            public void call(Subscriber<? super List<MapirWeatherItem>> subscriber) {
                try {

                    String responseString = getAllWeatherInfoApi();

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      List<MapirWeatherItem> entity = gsonMapper.fromJson(responseString, new TypeToken<List<MapirWeatherItem>>() {
                        }.getType());
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);
                }
            }
        });
    }

    private String getWeatherInfoApi(String param) throws Exception {
        String apiUrl = new String(URLHelper.WEATHER_URL) + param;
        return ApiConnection.createGET(apiUrl).call();
    }

    private String getAllWeatherInfoApi() throws Exception {
        String apiUrl = new String(URLHelper.WEATHER_ALL_URL);
        return ApiConnection.createGET(apiUrl).call();
    }

    @Override
    public Observable<MapirMedia> uploadMediaByFile(final String token, final File file) {
      return Observable.create(new Observable.OnSubscribe<MapirMedia>() {
            @Override
            public void call(Subscriber<? super MapirMedia> subscriber) {
                try {

                    String responseString = uploadMediaByFileApi(token, file);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirMedia entity = gsonMapper.fromJson(responseString, MapirMedia.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String uploadMediaByFileApi(String token, File file) throws Exception {
        return ApiConnection.createPOST(new String(URLHelper.UPLOAD_MEDIA_URL), file, token).call();
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> createOrModifyTag(final String token, final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirSimpleNetworkEntity>() {
            @Override
            public void call(Subscriber<? super MapirSimpleNetworkEntity> subscriber) {
                try {

                    String responseString = createOrModifyTagApi(token, params);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirSimpleNetworkEntity entity = gsonMapper.fromJson(responseString, MapirSimpleNetworkEntity.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String createOrModifyTagApi(String token, String params) throws Exception {
        return ApiConnection.createPOST(new String(URLHelper.TAG_BASE_URL), params, token).call();
    }

    @Override
    public Observable<ArrayList<MapirTag>> getTagList(final int type, final String token, final int skip) {
      return Observable.create(new Observable.OnSubscribe<ArrayList<MapirTag>>() {
            @Override
            public void call(Subscriber<? super ArrayList<MapirTag>> subscriber) {
                try {

                    String responseString = getTagListApi(type, token, skip);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      ArrayList<MapirTag> entity = gsonMapper.fromJson(responseString, new TypeToken<ArrayList<MapirTag>>() {
                        }.getType());
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String getTagListApi(int type, String token, int skip) throws Exception {
        String apiUrl = URLHelper.getLoadMoreTag(type, skip);

        return ApiConnection.createGET(apiUrl, token).call();
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> deleteTag(final String token, final String id) {
      return Observable.create(new Observable.OnSubscribe<MapirSimpleNetworkEntity>() {
            @Override
            public void call(Subscriber<? super MapirSimpleNetworkEntity> subscriber) {
                try {

                    String responseString = deleteTagApi(token, id);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirSimpleNetworkEntity entity = gsonMapper.fromJson(responseString, MapirSimpleNetworkEntity.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String deleteTagApi(String token, String params) throws Exception {
        String apiUrl = URLHelper.deleteTagURL(params);

        return ApiConnection.createDelete(apiUrl, token).call();
    }

    @Override
    public Observable<MapirSearchResponse> search(final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirSearchResponse>() {
            @Override
            public void call(Subscriber<? super MapirSearchResponse> subscriber) {
                try {

                    String responseString = searchPoiApi(params);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirSearchResponse entity = gsonMapper.fromJson(responseString, MapirSearchResponse.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }


    private String searchPoiApi(String params) throws Exception {

        return ApiConnection.createPOST(new String(URLHelper.SEARCH_ADDRESS_API), params).call();
    }

  @Override
  public Observable<MapirSearchResponse> autoCompleteSearch(final String params) {
    return Observable.create(new Observable.OnSubscribe<MapirSearchResponse>() {
      @Override
      public void call(Subscriber<? super MapirSearchResponse> subscriber) {
        try {

          String responseString = autoCompleteSearchApi(params);

          if (responseString == null) {
            subscriber.onError(new Throwable("Error From Server"));
          } else {
            MapirSearchResponse entity = gsonMapper.fromJson(responseString, MapirSearchResponse.class);
            subscriber.onNext(entity);
            subscriber.onCompleted();
          }

        } catch (Exception e) {
          subscriber.onError(e);

        }
      }
    });
  }


  private String autoCompleteSearchApi(String params) throws Exception {

    return ApiConnection.createPOST(new String(URLHelper.SEARCH_AUTO_COMPLETE_API), params).call();
  }

    @Override
    public Observable<MapirSearchPostCode> searchPostCode(final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirSearchPostCode>() {
            @Override
            public void call(Subscriber<? super MapirSearchPostCode> subscriber) {
                try {

                    String responseString = searchPostCodeApi(params);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirSearchPostCode entity = gsonMapper.fromJson(responseString, MapirSearchPostCode.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String searchPostCodeApi(String params) throws Exception {

        return ApiConnection.createGET(new String(URLHelper.SEARCH_POST_CODE_API) + params).call();
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> createBookmark(final String token, final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirSimpleNetworkEntity>() {
            @Override
            public void call(Subscriber<? super MapirSimpleNetworkEntity> subscriber) {
                try {
                    String responseString = createBookmarkApi(token, params);
                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirSimpleNetworkEntity entity = gsonMapper.fromJson(responseString, MapirSimpleNetworkEntity.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);
                }
            }
        });
    }

    private String createBookmarkApi(String token, String params) throws Exception {
        return ApiConnection.createPOST(new String(URLHelper.MAP_BOOKMARK_URL), params, token).call();
    }

    @Override
    public Observable<List<MapirBookmark>> getBookmarkList(final String token, final int skip) {
      return Observable.create(new Observable.OnSubscribe<List<MapirBookmark>>() {
            @Override
            public void call(Subscriber<? super List<MapirBookmark>> subscriber) {
                try {
                    String responseString = getBookmarkListApi(token, skip);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      List<MapirBookmark> entity = gsonMapper.fromJson(responseString, new TypeToken<List<MapirBookmark>>() {
                        }.getType());
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }
                } catch (Exception e) {
                    subscriber.onError(e);
                }
            }
        });
    }

    private String getBookmarkListApi(String token, int skip) throws Exception {
        String apiUrl = URLHelper.getBookmarkListURL(skip);
        return ApiConnection.createGET(apiUrl, token).call();
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> deleteBookmark(final String token, final String id) {
      return Observable.create(new Observable.OnSubscribe<MapirSimpleNetworkEntity>() {
            @Override
            public void call(Subscriber<? super MapirSimpleNetworkEntity> subscriber) {
                try {

                    String responseString = deleteBookmarkApi(token, id);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirSimpleNetworkEntity entity = gsonMapper.fromJson(responseString, MapirSimpleNetworkEntity.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String deleteBookmarkApi(String token, String id) throws Exception {
        String apiUrl = URLHelper.deleteBookmarkURL(id);

        return ApiConnection.createDelete(apiUrl, token).call();
    }


    @Override
    public Observable<MapirRouteResponse> getRouteInfo(final MapirLatLng startPosition, final MapirLatLng endPosition, final RouteMode routeMode) {
      return Observable.create(new Observable.OnSubscribe<MapirRouteResponse>() {
            @Override
            public void call(Subscriber<? super MapirRouteResponse> subscriber) {
                try {
                    boolean isEndInEvenOdd = false;
                    boolean isEndInTraffic = false;
                    boolean isStartInEvenOdd = false;
                    boolean isStartInTraffic = false;
                    String params = null;
                  List<MapirLatLng> evenOddPolygon = getEvenOddPolygonPoses();
                  List<MapirLatLng> trafficPolygon = getTrafficPolygonPoses();

                    if (MapUtils.containsLocation(startPosition, evenOddPolygon, true))
                        isStartInEvenOdd = true;
                    if (MapUtils.containsLocation(startPosition, trafficPolygon, true))
                        isStartInTraffic = true;
                    if (MapUtils.containsLocation(endPosition, evenOddPolygon, true))
                        isEndInEvenOdd = true;
                    if (MapUtils.containsLocation(endPosition, trafficPolygon, true))
                        isEndInTraffic = true;

                    switch (routeMode) {
                        case BASIC:
                            params = startPosition.longitude + "," + startPosition.latitude + ";"
                                    + endPosition.longitude + "," + endPosition.latitude
                                    + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            break;
                        case EVENODD:
                            if (!(isStartInEvenOdd && isEndInEvenOdd) && !(isEndInEvenOdd || isStartInEvenOdd)) {
                                params = startPosition.longitude + "," + startPosition.latitude + ";"
                                        + endPosition.longitude + "," + endPosition.latitude
                                        + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            } else if (isStartInEvenOdd && isEndInEvenOdd) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_evenodd_both_poses_inside)));
                                return;
                            } else if (isEndInEvenOdd || isStartInEvenOdd) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_evenodd_one_pos_inside)));
                                return;
                            }
                            break;
                        case TRAFFIC:
                            if (!(isStartInTraffic && isEndInTraffic) && !(isStartInTraffic || isEndInTraffic)) {
                                params = startPosition.longitude + "," + startPosition.latitude + ";"
                                        + endPosition.longitude + "," + endPosition.latitude
                                        + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            } else if (isStartInTraffic && isEndInTraffic) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_traffic_both_poses_inside)));
                                return;
                            } else if (isStartInTraffic || isEndInTraffic) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_traffic_one_pos_inside)));
                                return;
                            }
                            break;
                        case BOTH:
                            if (!(isStartInEvenOdd && isEndInEvenOdd) && !(isEndInEvenOdd || isStartInEvenOdd)) {
                                params = startPosition.longitude + "," + startPosition.latitude + ";"
                                        + endPosition.longitude + "," + endPosition.latitude
                                        + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            } else if (isStartInEvenOdd && isEndInEvenOdd) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_evenodd_both_poses_inside)));
                                return;
                            } else if (isEndInEvenOdd || isStartInEvenOdd) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_evenodd_one_pos_inside)));
                                return;
                            }
                            break;
                        case WALK:
                            params = startPosition.longitude + "," + startPosition.latitude + ";"
                                    + endPosition.longitude + "," + endPosition.latitude
                                    + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            break;

                        case BICYCLE:
                            params = startPosition.longitude + "," + startPosition.latitude + ";"
                                    + endPosition.longitude + "," + endPosition.latitude
                                    + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            break;
                    }
                    String responseString = getRouteInfoApi(routeMode, params);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirRouteResponse entity = gsonMapper.fromJson(responseString, MapirRouteResponse.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String getRouteInfoApi(RouteMode routeMode, String params) throws Exception {
        String apiUrl = "";
        switch (routeMode) {
            case BICYCLE:
                apiUrl = new String(URLHelper.BICYCLE_ROUTE_DRIVING_URL) + params;
                break;
            case WALK:
                apiUrl = new String(URLHelper.WALK_ROUTE_DRIVING_URL) + params;
                break;
            case BOTH:
                apiUrl = new String(URLHelper.EVENODD_ROUTE_DRIVING_URL) + params;
                break;
            case BASIC:
                apiUrl = new String(URLHelper.DEFAULT_ROUTE_DRIVING_URL) + params;
                break;
            case EVENODD:
                apiUrl = new String(URLHelper.EVENODD_ROUTE_DRIVING_URL) + params;
                break;
            case TRAFFIC:
                apiUrl = new String(URLHelper.TRAFFIC_ROUTE_DRIVING_URL) + params;
                break;
        }


        return ApiConnection.createGET(apiUrl).call();
    }


  private List<MapirLatLng> getEvenOddPolygonPoses() {
        MapUtils mapUtils = new MapUtils();
        return mapUtils.getEvenOddPoses();
    }

  private List<MapirLatLng> getTrafficPolygonPoses() {
        MapUtils mapUtils = new MapUtils();
        return mapUtils.getTrafficPoses();
    }


    @Override
    public Observable<MapirRouteResponse> getGlobalRouteInfo(final MapirLatLng startPosition, final MapirLatLng endPosition, final RouteMode routeMode) {
      return Observable.create(new Observable.OnSubscribe<MapirRouteResponse>() {
            @Override
            public void call(Subscriber<? super MapirRouteResponse> subscriber) {
                try {
                    boolean isEndInEvenOdd = false;
                    boolean isEndInTraffic = false;
                    boolean isStartInEvenOdd = false;
                    boolean isStartInTraffic = false;
                    String params = null;
                  List<MapirLatLng> evenOddPolygon = getEvenOddPolygonPoses();
                  List<MapirLatLng> trafficPolygon = getTrafficPolygonPoses();

                    if (MapUtils.containsLocation(startPosition, evenOddPolygon, true))
                        isStartInEvenOdd = true;
                    if (MapUtils.containsLocation(startPosition, trafficPolygon, true))
                        isStartInTraffic = true;
                    if (MapUtils.containsLocation(endPosition, evenOddPolygon, true))
                        isEndInEvenOdd = true;
                    if (MapUtils.containsLocation(endPosition, trafficPolygon, true))
                        isEndInTraffic = true;

                    switch (routeMode) {
                        case BASIC:
                            params = startPosition.longitude + "," + startPosition.latitude + ";"
                                    + endPosition.longitude + "," + endPosition.latitude
                                    + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            break;
                        case EVENODD:
                            if (!(isStartInEvenOdd && isEndInEvenOdd) && !(isEndInEvenOdd || isStartInEvenOdd)) {
                                params = startPosition.longitude + "," + startPosition.latitude + ";"
                                        + endPosition.longitude + "," + endPosition.latitude
                                        + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            } else if (isStartInEvenOdd && isEndInEvenOdd) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_evenodd_both_poses_inside)));
                                return;
                            } else if (isEndInEvenOdd || isStartInEvenOdd) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_evenodd_one_pos_inside)));
                                return;
                            }
                            break;
                        case TRAFFIC:
                            if (!(isStartInTraffic && isEndInTraffic) && !(isStartInTraffic || isEndInTraffic)) {
                                params = startPosition.longitude + "," + startPosition.latitude + ";"
                                        + endPosition.longitude + "," + endPosition.latitude
                                        + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            } else if (isStartInTraffic && isEndInTraffic) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_traffic_both_poses_inside)));
                                return;
                            } else if (isStartInTraffic || isEndInTraffic) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_traffic_one_pos_inside)));
                                return;
                            }
                            break;
                        case BOTH:
                            if (!(isStartInEvenOdd && isEndInEvenOdd) && !(isEndInEvenOdd || isStartInEvenOdd)) {
                                params = startPosition.longitude + "," + startPosition.latitude + ";"
                                        + endPosition.longitude + "," + endPosition.latitude
                                        + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            } else if (isStartInEvenOdd && isEndInEvenOdd) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_evenodd_both_poses_inside)));
                                return;
                            } else if (isEndInEvenOdd || isStartInEvenOdd) {
                                subscriber.onError(new Throwable(ServiceSDK.getContext().getResources().getString(R.string.route_evenodd_one_pos_inside)));
                                return;
                            }
                            break;
                        case WALK:
                            params = startPosition.longitude + "," + startPosition.latitude + ";"
                                    + endPosition.longitude + "," + endPosition.latitude
                                    + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            break;

                        case BICYCLE:
                            params = startPosition.longitude + "," + startPosition.latitude + ";"
                                    + endPosition.longitude + "," + endPosition.latitude
                                    + "?alternatives=true&steps=true&overview=false&hints=%3B";
                            break;
                    }
                    String responseString = getGlobalRouteInfoApi(routeMode, params);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirRouteResponse entity = gsonMapper.fromJson(responseString, MapirRouteResponse.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String getGlobalRouteInfoApi(RouteMode routeMode, String params) throws Exception {
        String apiUrl = "";
        switch (routeMode) {
            case BICYCLE:
                apiUrl = new String(URLHelper.BICYCLE_GLOBAL_ROUTE_DRIVING_URL) + params;
                break;
            case WALK:
                apiUrl = new String(URLHelper.WALK_GLOBAL_ROUTE_DRIVING_URL) + params;
                break;
            case BOTH:
                apiUrl = new String(URLHelper.EVENODD_GLOBAL_ROUTE_DRIVING_URL) + params;
                break;
            case BASIC:
                apiUrl = new String(URLHelper.DEFAULT_GLOBAL_ROUTE_DRIVING_URL) + params;
                break;
            case EVENODD:
                apiUrl = new String(URLHelper.EVENODD_GLOBAL_ROUTE_DRIVING_URL) + params;
                break;
            case TRAFFIC:
                apiUrl = new String(URLHelper.TRAFFIC_GLOBAL_ROUTE_DRIVING_URL) + params;
                break;
        }


        return ApiConnection.createGET(apiUrl).call();
    }

    @Override
    public Observable getStaticMap(final double latitude, final double longitude, int zoom) {
        return Observable.create(new Observable.OnSubscribe<Bitmap>() {
            @Override
            public void call(final Subscriber<? super Bitmap> subscriber) {
                try {

                    String url = String.format(STATIC_MAP,
                            450, 450,
                            longitude, latitude, 17);

                    ImageLoader.getInstance().loadImage(url, new ImageLoadingListener() {
                        @Override
                        public void onLoadingStarted(String imageUri, View view) {

                        }

                        @Override
                        public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                            subscriber.onError(failReason.getCause());
                        }

                        @Override
                        public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                            subscriber.onNext(loadedImage);
                        }

                        @Override
                        public void onLoadingCancelled(String imageUri, View view) {
                            subscriber.onError(new Throwable("Loading Image Cancelled"));
                        }
                    });

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    @Override
    public Observable<MapirNetworkEntity> sendFeedback(final RequestBody body) {
      return Observable.create(new Observable.OnSubscribe<MapirNetworkEntity>() {
            @Override
            public void call(Subscriber<? super MapirNetworkEntity> subscriber) {
                try {

                    String responseString = sendFeedbackApi(body);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirNetworkEntity entity = new MapirNetworkEntity();
                        entity.dispMessage = "success";
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String sendFeedbackApi(RequestBody body) throws Exception {
        return ApiConnection.createPOST(new String(URLHelper.SUPPORT_MAP_URL), body).call();
    }

    @Override
    public Observable<MapirLoginResponse> loginUser(final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirLoginResponse>() {
            @Override
            public void call(Subscriber<? super MapirLoginResponse> subscriber) {
                try {

                    String responseString = loginUserApi(params);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirLoginResponse entity = gsonMapper.fromJson(responseString, MapirLoginResponse.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String loginUserApi(String params) throws Exception {
        return ApiConnection.createPOST(new String(SIGN_IN_OUT_URL), params).call();
    }

    @Override
    public Observable<MapirForgotEntity> forgetPassword(final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirForgotEntity>() {
            @Override
            public void call(Subscriber<? super MapirForgotEntity> subscriber) {
                try {
                    String responseString = forgetPasswordApi(params);
                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirForgotEntity entity = gsonMapper.fromJson(responseString, MapirForgotEntity.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);
                }
            }
        });
    }

    private String forgetPasswordApi(String params) throws Exception {
        String apiUrl = new String(FORGOT_PASSWORD_URL);
        return ApiConnection.createGET(apiUrl + "user=" + params).call();
    }

    @Override
    public Observable<MapirAuthenticateResponse> signupUser(final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirAuthenticateResponse>() {
            @Override
            public void call(Subscriber<? super MapirAuthenticateResponse> subscriber) {
                try {

                    String responseString = signupUserApi(params);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirAuthenticateResponse entity = gsonMapper.fromJson(responseString, MapirAuthenticateResponse.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String signupUserApi(String params) throws Exception {
        return ApiConnection.createPOST(new String(SIGN_UP_URL), params).call();
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> signoutUser(final String token) {
      return Observable.create(new Observable.OnSubscribe<MapirSimpleNetworkEntity>() {
            @Override
            public void call(Subscriber<? super MapirSimpleNetworkEntity> subscriber) {
                try {

                    String responseString = signoutUserApi(token);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirSimpleNetworkEntity entity = gsonMapper.fromJson(responseString, MapirSimpleNetworkEntity.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String signoutUserApi(String token) throws Exception {
        return ApiConnection.createDelete(new String(SIGN_IN_OUT_URL), token).call();
    }

    @Override
    public Observable<MapirLoginResponse> loginUserByGmail(final String token) {
      return Observable.create(new Observable.OnSubscribe<MapirLoginResponse>() {
            @Override
            public void call(Subscriber<? super MapirLoginResponse> subscriber) {
                try {

                    String responseString = loginUserByGmailApi(token);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirLoginResponse entity = gsonMapper.fromJson(responseString, MapirLoginResponse.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String loginUserByGmailApi(String token) throws Exception {
        String apiUrl = new String(LOCAL_URL_GMAIL_LOGIN) + token;
        return ApiConnection.createGET(apiUrl).call();
    }

    @Override
    public Observable<MapirAuthenticateResponse> verifyUser(final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirAuthenticateResponse>() {
            @Override
            public void call(Subscriber<? super MapirAuthenticateResponse> subscriber) {
                try {

                    String responseString = verifyUserApi(params);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirAuthenticateResponse entity = gsonMapper.fromJson(responseString, MapirAuthenticateResponse.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String verifyUserApi(String params) throws Exception {
        String apiUrl = new String(VERIFICATION_CODE_URL) + params;
        return ApiConnection.createPOST(apiUrl).call();
    }

    @Override
    public Observable<MapirResendVerification> resendVerificationCode(final String params) {
      return Observable.create(new Observable.OnSubscribe<MapirResendVerification>() {
            @Override
            public void call(Subscriber<? super MapirResendVerification> subscriber) {
                try {

                    String responseString = resendVerificationCodeApi(params);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirResendVerification entity = gsonMapper.fromJson(responseString, MapirResendVerification.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String resendVerificationCodeApi(String params) throws Exception {
        String apiUrl = new String(VERIFICATION_CODE_URL) + params;
        return ApiConnection.createPOST(apiUrl).call();
    }

    @Override
    public Observable<List<MapirTag>> getTag(final String token, final String params) {
      return Observable.create(new Observable.OnSubscribe<List<MapirTag>>() {
            @Override
            public void call(Subscriber<? super List<MapirTag>> subscriber) {
                try {

                    String responseString = getTagApi(token, params);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      List<MapirTag> entity = gsonMapper.fromJson(responseString, new TypeToken<List<MapirTag>>() {
                        }.getType());
//                        List<MapirTag> entity = gsonMapper.fromJson(responseString, List<MapirTag>.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String getTagApi(String token, String body) throws Exception {
        String apiUrl = URLHelper.getTagURL(body);

        return ApiConnection.createGET(apiUrl, token).call();
    }

    @Override
    public Observable<MapirProfileResponse> getProfile(final String userName, final String token) {

      return Observable.create(new Observable.OnSubscribe<MapirProfileResponse>() {
            @Override
            public void call(Subscriber<? super MapirProfileResponse> subscriber) {
                try {

                    String responseString = getProfileApi(userName, token);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirProfileResponse entity = gsonMapper.fromJson(responseString, MapirProfileResponse.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    private String getProfileApi(String userName, String token) throws Exception {
        String apiUrl = new String(GET_PROFILE) + userName;

        return ApiConnection.createGET(apiUrl, token).call();
    }


    @Override
    public Observable<MapirProfileResponse> updateProfile(final String userName, final String token, final String body) {
      return Observable.create(new Observable.OnSubscribe<MapirProfileResponse>() {
            @Override
            public void call(Subscriber<? super MapirProfileResponse> subscriber) {
                try {

                    String responseString = updateProfileApi(userName, token, body);

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirProfileResponse entity = gsonMapper.fromJson(responseString, MapirProfileResponse.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

    @Override
    public Observable<MapirPublicTransportResponse> getPublicTrnasportRoute(final MapirLatLng startPosition,
                                                                            final MapirLatLng endPosition,
                                                                            final Double walkDistance,
                                                                            final PublicTransportMode routeMode) {
      return Observable.create(new Observable.OnSubscribe<MapirPublicTransportResponse>() {
            @Override
            public void call(Subscriber<? super MapirPublicTransportResponse> subscriber) {
                try {

                    String currentTime = getCurrentTime();
                    String currentDate = getCurrentDate();

                    String responseString = getPublicTrnasportRouteApi(startPosition, endPosition,
                            currentTime, currentDate, walkDistance,
                            routeMode.params());

                    if (responseString == null) {
                        subscriber.onError(new Throwable("Error From Server"));
                    } else {
                      MapirPublicTransportResponse entity = gsonMapper.fromJson(responseString, MapirPublicTransportResponse.class);
                        subscriber.onNext(entity);
                        subscriber.onCompleted();
                    }

                } catch (Exception e) {
                    subscriber.onError(e);

                }
            }
        });
    }

  private String getPublicTrnasportRouteApi(MapirLatLng startPosition, MapirLatLng endPosition, String currentTime,
                                            String currentDate, Double walkDistance, String routeMode) throws Exception {
        String apiUrl = URLHelper.getPublicTransportURL(startPosition, endPosition, currentTime, currentDate, walkDistance, routeMode);

        return ApiConnection.createGET(apiUrl).call();
    }

    private String getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return (calendar.get(Calendar.MONTH) + 1 > 9 ? String.valueOf(calendar.get(Calendar.MONTH) + 1) : "0" + String.valueOf(calendar.get(Calendar.MONTH) + 1))
                + "-" + (calendar.get(Calendar.DAY_OF_MONTH) > 9 ? String.valueOf(calendar.get(Calendar.DAY_OF_MONTH)) : ("0" + calendar.get(Calendar.DAY_OF_MONTH)))
                + "-" + calendar.get(Calendar.YEAR);
    }

    private String getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.HOUR_OF_DAY) + ":" + calendar.get(Calendar.MINUTE) +
                (calendar.get(Calendar.HOUR_OF_DAY) > 11 ? "p" : "a");
    }

    private String updateProfileApi(String userName, String token, String body) throws Exception {
        String apiUrl = new String(UPDATE_PROFILE) + userName;

        return ApiConnection.createPUT(apiUrl, token, body).call();
    }

  public ArrayList<MapirLatLng> getEvenOddPoses(Context context) {
        return getMapPoses(context, "even-odd");
    }

  public ArrayList<MapirLatLng> getTrafficPoses(Context context) {
        return getMapPoses(context, "traffic");
    }

  private ArrayList<MapirLatLng> getMapPoses(Context context, String type) {
    ArrayList<MapirLatLng> latLngs = new ArrayList<>();
        String json = loadJSONFromAsset(context, type);
        if (json != null) {
            try {
                JSONArray jsonArray = new JSONArray(json);
                for (int i = 0; i < jsonArray.length(); i++) {
                  latLngs.add(new MapirLatLng(jsonArray.getJSONArray(i).getDouble(1), jsonArray.getJSONArray(i).getDouble(0)));
                }

            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return latLngs;
    }

    private String loadJSONFromAsset(Context context, String type) {
        String json = null;
        try {
            InputStream is = null;
            switch (type) {
                case "traffic":
                    is = context.getAssets().open("traffic-json.json");
                    break;
                case "even-odd":
                    is = context.getAssets().open("even-odd.json");
                    break;
                case "earthqueke":
                    is = context.getAssets().open("earthqueke.geojson");
                    break;
                case "metro_stations_isfahan":
                    is = context.getAssets().open("metro_stations_isfahan.geojson");
                    break;
                case "metro_lines_isfahan":
                    is = context.getAssets().open("metro_lines_isfahan.geojson");
                    break;
                case "metro_stations_mashhad":
                    is = context.getAssets().open("metro_stations_mashhad.geojson");
                    break;
                case "metro_lines_mashhad":
                    is = context.getAssets().open("metro_lines_mashhad.geojson");
                    break;
                case "metro_stations_shiraz":
                    is = context.getAssets().open("metro_stations_shiraz.geojson");
                    break;
                case "metro_lines_shiraz":
                    is = context.getAssets().open("metro_lines_shiraz.geojson");
                    break;
                case "metro_stations_tabriz":
                    is = context.getAssets().open("metro_stations_tabriz.geojson");
                    break;
                case "metro_lines_tabriz":
                    is = context.getAssets().open("metro_lines_tabriz.geojson");
                    break;
                case "metro_stations_tehran":
                    is = context.getAssets().open("metro_stations_tehran.geojson");
                    break;
                case "metro_lines_tehran":
                    is = context.getAssets().open("metro_lines_tehran.geojson");
                    break;
                case "bus_lines":
                    is = context.getAssets().open("bus_lines.geojson");
                    break;
                case "bus_stations":
                    is = context.getAssets().open("bus_stations.geojson");
                    break;
            }
            if (is != null) {
                int size = is.available();
                byte[] buffer = new byte[size];
                is.read(buffer);
                is.close();
                json = new String(buffer, "UTF-8");
            }
        } catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }

        return json;
    }
}
