package ir.map.sdk_services.network;

import java.io.File;
import java.net.MalformedURLException;

import ir.map.sdk_services.network.base.HttpDeleteRequest;
import ir.map.sdk_services.network.base.HttpGetRequest;
import ir.map.sdk_services.network.base.HttpPostRequest;
import ir.map.sdk_services.network.base.HttpPutRequest;
import ir.map.sdk_services.network.base.HttpRequest;
import okhttp3.RequestBody;


/**
 * Api Connection class used to retrieve data from the cloud.
 * Implements {@link java.util.concurrent.Callable} so when executed asynchronously can
 * return a value.
 */
public class ApiConnection {

    public static HttpRequest createGET(String url) {
        return new HttpGetRequest(url);

    }

    public static HttpRequest createGET(String url, String token) {
        return new HttpGetRequest(url, token);

    }

    public static HttpRequest createPOST(String url, String body) throws MalformedURLException {
        return new HttpPostRequest(url, body);
    }

    public static HttpRequest createPOST(String url, RequestBody body) {
        return new HttpPostRequest(url, body);
    }

    public static HttpRequest createPOST(String url) throws MalformedURLException {
        return new HttpPostRequest(url);
    }

    public static HttpRequest createPOST(String url, String body, String token) throws MalformedURLException {
        return new HttpPostRequest(url, body, token);
    }

    public static HttpRequest createDelete(String url, String token) throws MalformedURLException {
        return new HttpDeleteRequest(url, token);
    }

    public static HttpRequest createPOST(String url, File file, String token) throws MalformedURLException {
        return new HttpPostRequest(url, file, token);
    }

    public static HttpRequest createPUT(String url, String token, String body) {
        return new HttpPutRequest(url, body, token);
    }
}
