package ir.map.sdk_services.models;

import com.google.gson.annotations.SerializedName;

import java.util.List;

import ir.map.sdk_services.models.base.MaptexEntity;

/**
 * @author Haniyeh Khaksar
 */

public class MaptexReverse extends MaptexEntity {

    @SerializedName("address_compact")
    public String addressCompact;
    @SerializedName("country")
    public String country;
    @SerializedName("province")
    public String province;
    @SerializedName("county")
    public String county;
    @SerializedName("city")
    public String city;
    @SerializedName("district")
    public String district;
    @SerializedName("region")
    public String region;
    @SerializedName("primary")
    public String primary;
    @SerializedName("last")
    public String last;
    @SerializedName("poi")
    public String poi;
    @SerializedName("plaque")
    public String plaque;
    @SerializedName("postal_code")
    public String postalCode;
    @SerializedName("geom")
    public GEOM geom;

    class GEOM extends MaptexEntity {
        @SerializedName("type")
        public String type;
        @SerializedName("coordinates")
        public List<Double> coordinates;
    }
}
