package ir.map.sdk_services.repository;

import android.graphics.Bitmap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_services.PublicTransportMode;
import ir.map.sdk_services.RouteMode;
import ir.map.sdk_services.models.MaptexAuthenticateResponse;
import ir.map.sdk_services.models.MaptexBookmark;
import ir.map.sdk_services.models.MaptexForgotEntity;
import ir.map.sdk_services.models.MaptexLoginResponse;
import ir.map.sdk_services.models.MaptexMedia;
import ir.map.sdk_services.models.MaptexNetworkEntity;
import ir.map.sdk_services.models.MaptexProfileResponse;
import ir.map.sdk_services.models.MaptexPublicTransportResponse;
import ir.map.sdk_services.models.MaptexResendVerification;
import ir.map.sdk_services.models.MaptexReverse;
import ir.map.sdk_services.models.MaptexRouteResponse;
import ir.map.sdk_services.models.MaptexSearchPostCode;
import ir.map.sdk_services.models.MaptexSearchResponse;
import ir.map.sdk_services.models.MaptexSimpleNetworkEntity;
import ir.map.sdk_services.models.MaptexTag;
import ir.map.sdk_services.models.MaptexTicket;
import ir.map.sdk_services.models.MaptexWeatherItem;
import ir.map.sdk_services.network.RestApi;
import ir.map.sdk_services.network.RestApiImpl;
import okhttp3.RequestBody;
import rx.Observable;

/**
 * @author Haniyeh Khaksar
 */

public class NetworkRepository implements INetworkRepository {

    private RestApi restApi = null;

    public NetworkRepository() {
        restApi = new RestApiImpl();
    }

    @Override
    public Observable<MaptexReverse> getReverseGeoInfo(String params) {
        return restApi.getReverseGeoInfo(params);
    }

    @Override
    public Observable<MaptexWeatherItem> getWeatherInfo(String params) {
        return restApi.getWeatherInfo(params);
    }

    @Override
    public Observable<List<MaptexWeatherItem>> getAllWeatherInfo() {
        return restApi.getAllWeatherInfo();
    }

//    @Override
//    public Observable<List<MaptexSearch>> getPointOfInterests() {
//        return restApi.getPointOfInterests();
//    }

    @Override
    public Observable<MaptexSimpleNetworkEntity> sendTicket(String token, String params) {
        return restApi.sendTicket(token, params);
    }

    @Override
    public Observable<MaptexSimpleNetworkEntity> sendReportTicket(String token, String params) {
        return restApi.sendReportTicket(token, params);
    }

    @Override
    public Observable<List<MaptexTicket>> getTicketList(String token) {
        return restApi.getTicketList(token);
    }

    @Override
    public Observable<MaptexMedia> uploadMediaByPath(String token, String path) {
        return restApi.uploadMediaByPath(token, path);
    }

    @Override
    public Observable<MaptexMedia> uploadMediaByFile(String token, File file) {
        return restApi.uploadMediaByFile(token, file);
    }

    @Override
    public Observable<MaptexSimpleNetworkEntity> createOrModifyTag(String token, String params) {
        return restApi.createOrModifyTag(token, params);
    }

    @Override
    public Observable<ArrayList<MaptexTag>> getTagList(int type, String token, int skip) {
        return restApi.getTagList(type, token, skip);
    }

    @Override
    public Observable<MaptexSimpleNetworkEntity> deleteTag(String token, String id) {
        return restApi.deleteTag(token, id);
    }

    @Override
    public Observable<MaptexSearchResponse> search(String params) {
        return restApi.search(params);
    }

    @Override
    public Observable<MaptexSearchPostCode> searchPostCode(String params) {
        return restApi.searchPostCode(params);
    }

    @Override
    public Observable<MaptexSimpleNetworkEntity> createBookmark(String token, String params) {
        return restApi.createBookmark(token, params);
    }

    @Override
    public Observable<List<MaptexBookmark>> getBookmarkList(String token, int skip) {
        return restApi.getBookmarkList(token, skip);
    }

    @Override
    public Observable<MaptexSimpleNetworkEntity> deleteBookmark(String token, String id) {
        return restApi.deleteBookmark(token, id);
    }

    @Override
    public Observable<MaptexRouteResponse> getRouteInfo(MaptexLatLng startPosition, MaptexLatLng endPosition, RouteMode routeMode) {
        return restApi.getRouteInfo(startPosition, endPosition, routeMode);
    }

    @Override
    public Observable<MaptexRouteResponse> getGlobalRouteInfo(MaptexLatLng startPosition, MaptexLatLng endPosition, RouteMode routeMode) {
        return restApi.getGlobalRouteInfo(startPosition, endPosition, routeMode);
    }

    @Override
    public Observable<Bitmap> getStaticMap(double latitude, double longitude, int zoom) {
        return restApi.getStaticMap(latitude, longitude, zoom);
    }

    @Override
    public Observable<MaptexNetworkEntity> sendFeedback(RequestBody body) {
        return restApi.sendFeedback(body);
    }

    @Override
    public Observable<MaptexLoginResponse> loginUser(String params) {
        return restApi.loginUser(params);
    }

    @Override
    public Observable<MaptexForgotEntity> forgetPassword(String params) {
        return restApi.forgetPassword(params);
    }

    @Override
    public Observable<MaptexAuthenticateResponse> signupUser(String authParams) {
        return restApi.signupUser(authParams);
    }

    @Override
    public Observable<MaptexSimpleNetworkEntity> signoutUser(String token) {
        return restApi.signoutUser(token);
    }

    @Override
    public Observable<MaptexLoginResponse> loginUserByGmail(String token) {
        return restApi.loginUserByGmail(token);
    }

    @Override
    public Observable<MaptexAuthenticateResponse> verifyUser(String params) {
        return restApi.verifyUser(params);
    }

    @Override
    public Observable<MaptexResendVerification> resendVerificationCode(String params) {
        return restApi.resendVerificationCode(params);
    }

    @Override
    public Observable<List<MaptexTag>> getTag(String token, String params) {
        return restApi.getTag(token, params);
    }

    @Override
    public Observable<MaptexProfileResponse> getProfile(String userName, String token) {
        return restApi.getProfile(userName, token);
    }

    @Override
    public Observable<MaptexProfileResponse> updateProfile(String userName, String token, String params) {
        return restApi.updateProfile(userName, token, params);
    }

    @Override
    public Observable<MaptexPublicTransportResponse> getPublicTrnasportRoute(MaptexLatLng startPosition,
                                                                             MaptexLatLng endPosition,
                                                                             Double walkDistance,
                                                                             PublicTransportMode routeMode) {
        return restApi.getPublicTrnasportRoute(startPosition, endPosition, walkDistance, routeMode);
    }

}
