/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_services;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_services.ServiceSDK;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class MapUtils {
    public static double wrap(double d2, double d3, double d4) {
        return d2 >= d3 && d2 < d4 ? d2 : MapUtils.mod(d2 - d3, d4 - d3) + d3;
    }

    static double mod(double d2, double d3) {
        return (d2 % d3 + d3) % d3;
    }

    public static boolean containsLocation(MaptexLatLng maptexLatLng, List<MaptexLatLng> list, boolean bl) {
        return MapUtils.containsLocation(maptexLatLng.latitude, maptexLatLng.longitude, list, bl);
    }

    public static boolean containsLocation(double d2, double d3, List<MaptexLatLng> list, boolean bl) {
        int n = list.size();
        if (n == 0) {
            return false;
        }
        double d4 = Math.toRadians(d2);
        double d5 = Math.toRadians(d3);
        MaptexLatLng maptexLatLng = list.get(n - 1);
        double d6 = Math.toRadians(maptexLatLng.latitude);
        double d7 = Math.toRadians(maptexLatLng.longitude);
        int n2 = 0;
        for (MaptexLatLng maptexLatLng2 : list) {
            double d8;
            double d9 = MapUtils.wrap(d5 - d7, -Math.PI, Math.PI);
            if (d4 == d6 && d9 == 0.0) {
                return true;
            }
            double d10 = Math.toRadians(maptexLatLng2.latitude);
            if (MapUtils.intersects(d6, d10, MapUtils.wrap((d8 = Math.toRadians(maptexLatLng2.longitude)) - d7, -Math.PI, Math.PI), d4, d9, bl)) {
                ++n2;
            }
            d6 = d10;
            d7 = d8;
        }
        return n2 & true;
    }

    private static boolean intersects(double d2, double d3, double d4, double d5, double d6, boolean bl) {
        if ((d6 < 0.0 || d6 < d4) && (d6 >= 0.0 || d6 >= d4)) {
            if (d5 <= -1.5707963267948966) {
                return false;
            }
            if (d2 > -1.5707963267948966 && d3 > -1.5707963267948966 && d2 < 1.5707963267948966 && d3 < 1.5707963267948966) {
                if (d4 <= -Math.PI) {
                    return false;
                }
                double d7 = (d2 * (d4 - d6) + d3 * d6) / d4;
                return d2 >= 0.0 && d3 >= 0.0 && d5 < d7 ? false : (d2 <= 0.0 && d3 <= 0.0 && d5 >= d7 ? true : (d5 >= 1.5707963267948966 ? true : (bl ? Math.tan(d5) >= MapUtils.tanLatGC(d2, d3, d4, d6) : MapUtils.mercator(d5) >= MapUtils.mercatorLatRhumb(d2, d3, d4, d6))));
            }
            return false;
        }
        return false;
    }

    private static double tanLatGC(double d2, double d3, double d4, double d5) {
        return (Math.tan(d2) * Math.sin(d4 - d5) + Math.tan(d3) * Math.sin(d5)) / Math.sin(d4);
    }

    static double mercator(double d2) {
        return Math.log(Math.tan(d2 * 0.5 + 0.7853981633974483));
    }

    private static double mercatorLatRhumb(double d2, double d3, double d4, double d5) {
        return (MapUtils.mercator(d2) * (d4 - d5) + MapUtils.mercator(d3) * d5) / d4;
    }

    public ArrayList<MaptexLatLng> getEvenOddPoses() {
        return this.getMapPoses("even-odd");
    }

    public ArrayList<MaptexLatLng> getTrafficPoses() {
        return this.getMapPoses("traffic");
    }

    private ArrayList<MaptexLatLng> getMapPoses(String string2) {
        ArrayList<MaptexLatLng> arrayList = new ArrayList<MaptexLatLng>();
        String string3 = this.loadJSONFromAsset(string2);
        if (string3 != null) {
            try {
                JSONArray jSONArray = new JSONArray(string3);
                for (int i = 0; i < jSONArray.length(); ++i) {
                    arrayList.add(new MaptexLatLng(jSONArray.getJSONArray(i).getDouble(1), jSONArray.getJSONArray(i).getDouble(0)));
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return arrayList;
    }

    private String loadJSONFromAsset(String string2) {
        String string3 = null;
        try {
            InputStream inputStream = null;
            switch (string2) {
                case "traffic": {
                    inputStream = ServiceSDK.getContext().getAssets().open("traffic-json.json");
                    break;
                }
                case "even-odd": {
                    inputStream = ServiceSDK.getContext().getAssets().open("even-odd.json");
                    break;
                }
                case "earthqueke": {
                    inputStream = ServiceSDK.getContext().getAssets().open("earthqueke.geojson");
                    break;
                }
                case "metro_stations_isfahan": {
                    inputStream = ServiceSDK.getContext().getAssets().open("metro_stations_isfahan.geojson");
                    break;
                }
                case "metro_lines_isfahan": {
                    inputStream = ServiceSDK.getContext().getAssets().open("metro_lines_isfahan.geojson");
                    break;
                }
                case "metro_stations_mashhad": {
                    inputStream = ServiceSDK.getContext().getAssets().open("metro_stations_mashhad.geojson");
                    break;
                }
                case "metro_lines_mashhad": {
                    inputStream = ServiceSDK.getContext().getAssets().open("metro_lines_mashhad.geojson");
                    break;
                }
                case "metro_stations_shiraz": {
                    inputStream = ServiceSDK.getContext().getAssets().open("metro_stations_shiraz.geojson");
                    break;
                }
                case "metro_lines_shiraz": {
                    inputStream = ServiceSDK.getContext().getAssets().open("metro_lines_shiraz.geojson");
                    break;
                }
                case "metro_stations_tabriz": {
                    inputStream = ServiceSDK.getContext().getAssets().open("metro_stations_tabriz.geojson");
                    break;
                }
                case "metro_lines_tabriz": {
                    inputStream = ServiceSDK.getContext().getAssets().open("metro_lines_tabriz.geojson");
                    break;
                }
                case "metro_stations_tehran": {
                    inputStream = ServiceSDK.getContext().getAssets().open("metro_stations_tehran.geojson");
                    break;
                }
                case "metro_lines_tehran": {
                    inputStream = ServiceSDK.getContext().getAssets().open("metro_lines_tehran.geojson");
                    break;
                }
                case "bus_lines": {
                    inputStream = ServiceSDK.getContext().getAssets().open("bus_lines.geojson");
                    break;
                }
                case "bus_stations": {
                    inputStream = ServiceSDK.getContext().getAssets().open("bus_stations.geojson");
                }
            }
            if (inputStream != null) {
                int n = inputStream.available();
                byte[] byArray = new byte[n];
                inputStream.read(byArray);
                inputStream.close();
                string3 = new String(byArray, "UTF-8");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return string3;
    }
}

