package ir.map.sdk_services;

import android.graphics.Bitmap;

import com.google.gson.Gson;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_services.models.MaptexAuthenticate;
import ir.map.sdk_services.models.MaptexAuthenticateResponse;
import ir.map.sdk_services.models.MaptexBookmark;
import ir.map.sdk_services.models.MaptexError;
import ir.map.sdk_services.models.MaptexForgotEntity;
import ir.map.sdk_services.models.MaptexGeometry;
import ir.map.sdk_services.models.MaptexLogin;
import ir.map.sdk_services.models.MaptexLoginResponse;
import ir.map.sdk_services.models.MaptexMedia;
import ir.map.sdk_services.models.MaptexNetworkEntity;
import ir.map.sdk_services.models.MaptexProfile;
import ir.map.sdk_services.models.MaptexProfileResponse;
import ir.map.sdk_services.models.MaptexReportTicket;
import ir.map.sdk_services.models.MaptexResendVerification;
import ir.map.sdk_services.models.MaptexReverse;
import ir.map.sdk_services.models.MaptexRouteResponse;
import ir.map.sdk_services.models.MaptexSearch;
import ir.map.sdk_services.models.MaptexSearchPostCode;
import ir.map.sdk_services.models.MaptexSearchResponse;
import ir.map.sdk_services.models.MaptexSimpleNetworkEntity;
import ir.map.sdk_services.models.MaptexTag;
import ir.map.sdk_services.models.MaptexTicket;
import ir.map.sdk_services.models.MaptexWeatherItem;
import ir.map.sdk_services.models.base.ResponseListener;
import ir.map.sdk_services.repository.NetworkRepository;
import okhttp3.RequestBody;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

/**
 * @author haniyeh khaksar
 */

public class ServiceHelper {

    private NetworkRepository repository;

    public ServiceHelper() {
        repository = new NetworkRepository();
    }

    public void getWeatherInfo(Double latitude, Double longitude, final ResponseListener<MaptexWeatherItem> listener) {
//        String params = String.format("lat=%s&lon=%s&units=metric&appid=%s", latitude, longitude, URLHelper.OPEN_WEATEHR_MAP_KEY);
        repository.getWeatherInfo(latitude + "," + longitude).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexWeatherItem>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexWeatherItem maptexWeatherItem) {
                        listener.onSuccess(maptexWeatherItem);
                    }
                });
    }

    public void getAllWeatherInfo(final ResponseListener<List<MaptexWeatherItem>> listener) {
        repository.getAllWeatherInfo().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<List<MaptexWeatherItem>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(List<MaptexWeatherItem> maptexWeatherItem) {
                        listener.onSuccess(maptexWeatherItem);
                    }
                });
    }

    public void sendTicket(String token, final MaptexTicket ticket, final ResponseListener<MaptexSimpleNetworkEntity> listener) {

        String ticketJson = new Gson().toJson(ticket);
        repository.sendTicket(token, ticketJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexSimpleNetworkEntity maptexSimpleNetworkEntity) {
                        listener.onSuccess(maptexSimpleNetworkEntity);
                    }
                });


    }

    public void sendReportTicket(String token, final String tagId, final ResponseListener<MaptexSimpleNetworkEntity> listener) {
        MaptexReportTicket reportTicket = new MaptexReportTicket();
        reportTicket.description = "tag:" + tagId;
        String ticketJson = new Gson().toJson(reportTicket);
        repository.sendReportTicket(token, ticketJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexSimpleNetworkEntity maptexSimpleNetworkEntity) {
                        listener.onSuccess(maptexSimpleNetworkEntity);
                    }
                });


    }

    public void getReverseGeoInfo(Double latitude, Double longitude, final ResponseListener<MaptexReverse> listener) {
        String params = String.format("lat=%s&lon=%s", latitude, longitude);
        repository.getReverseGeoInfo(params).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexReverse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexReverse maptexReverse) {
                        listener.onSuccess(maptexReverse);
                    }
                });
    }

    public void getTicketList(String token, final ResponseListener<List<MaptexTicket>> listener) {
        repository.getTicketList(token).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<List<MaptexTicket>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(List<MaptexTicket> maptexTickets) {
                        listener.onSuccess(maptexTickets);
                    }
                });


    }

    public void uploadMediasByPath(String token, final List<String> mediaPaths, final ResponseListener<List<MaptexMedia>> listener) {
        final List<MaptexMedia> medias = new ArrayList<>();
        for (String path : mediaPaths) {
            repository.uploadMediaByPath(token, path).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                    .subscribe(new Subscriber<MaptexMedia>() {
                        @Override
                        public void onCompleted() {

                        }

                        @Override
                        public void onError(Throwable e) {
                            listener.onError(new MaptexError(e.getMessage()));
                        }

                        @Override
                        public void onNext(MaptexMedia maptexMedia) {
                            medias.add(maptexMedia);
                            if (medias.size() == mediaPaths.size()) {
                                listener.onSuccess(medias);
                            }
                        }
                    });
        }

    }

    public void uploadMediasByFile(String token, final List<File> mediaFiles, final ResponseListener<List<MaptexMedia>> listener) {
        final List<MaptexMedia> medias = new ArrayList<>();
        for (File file : mediaFiles) {
            repository.uploadMediaByFile(token, file).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                    .subscribe(new Subscriber<MaptexMedia>() {
                        @Override
                        public void onCompleted() {

                        }

                        @Override
                        public void onError(Throwable e) {
                            listener.onError(new MaptexError(e.getMessage()));
                        }

                        @Override
                        public void onNext(MaptexMedia maptexMedia) {
                            medias.add(maptexMedia);
                            if (medias.size() == mediaFiles.size()) {
                                listener.onSuccess(medias);
                            }
                        }
                    });
        }

    }

    public void createOrModifyTag(String token, final MaptexTag maptexTag, final ResponseListener<MaptexSimpleNetworkEntity> listener) {

        String tagJson = new Gson().toJson(maptexTag);
        repository.createOrModifyTag(token, tagJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexSimpleNetworkEntity simpleNetworkEntity) {
                        listener.onSuccess(simpleNetworkEntity);
                    }
                });

    }

    public void getTagList(int type, String token, final int skip, final ResponseListener<ArrayList<MaptexTag>> listener) {

        repository.getTagList(type, token, skip).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<ArrayList<MaptexTag>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(ArrayList<MaptexTag> maptexTags) {
                        listener.onSuccess(maptexTags);
                    }
                });

    }

    public void deleteTag(String token, final String id, final ResponseListener<MaptexSimpleNetworkEntity> listener) {

        repository.deleteTag(token, id).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexSimpleNetworkEntity maptexTags) {
                        listener.onSuccess(maptexTags);
                    }
                });

    }

    public void search(String text, Double lat, Double lng, List<MaptexLatLng> coordinates, final ResponseListener<MaptexSearchResponse> listener) {
        MaptexSearch maptexSearch = new MaptexSearch();
        maptexSearch.text = text;
        maptexSearch.location = new MaptexGeometry();
        maptexSearch.location.coordinates = new ArrayList<>();
        maptexSearch.location.coordinates.add(lng);
        maptexSearch.location.coordinates.add(lat);
        maptexSearch.location.type = "Point";
//        maptexSearch.top = "10";
        if (coordinates != null && !coordinates.isEmpty()) {
            maptexSearch.geom = new MaptexSearch.MaptexPosition();
            maptexSearch.geom.coordinates = new ArrayList<>();
            List<Double> pos;
            for (int i = 0; i < coordinates.size(); i++) {
                pos = new ArrayList<>();
                pos.add(coordinates.get(i).longitude);
                pos.add(coordinates.get(i).latitude);
                maptexSearch.geom.coordinates.add(pos);
                if (i == coordinates.size() - 1) {
                    pos = new ArrayList<>();
                    pos.add(coordinates.get(0).longitude);
                    pos.add(coordinates.get(0).latitude);
                    maptexSearch.geom.coordinates.add(pos);
                }
            }
            maptexSearch.geom.type = "Polygon";
        }

        String searchJson = new Gson().toJson(maptexSearch);
        repository.search(searchJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexSearchResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexSearchResponse maptexSearchs) {
                        listener.onSuccess(maptexSearchs);
                    }
                });
    }

    public void searchPostCode(String text, final ResponseListener<MaptexSearchPostCode> listener) {
        repository.searchPostCode(text).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexSearchPostCode>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexSearchPostCode maptexSearchs) {
                        listener.onSuccess(maptexSearchs);
                    }
                });
    }

    public void createBookmark(String token, final MaptexBookmark maptexBookmark, final ResponseListener<MaptexSimpleNetworkEntity> listener) {

        String bookmarkJson = new Gson().toJson(maptexBookmark);
        repository.createBookmark(token, bookmarkJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexSimpleNetworkEntity simpleNetworkEntity) {
                        listener.onSuccess(simpleNetworkEntity);
                    }
                });

    }

    public void getBookmarkList(String token, final int skip, final ResponseListener<List<MaptexBookmark>> listener) {

        repository.getBookmarkList(token, skip).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<List<MaptexBookmark>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(List<MaptexBookmark> maptexBookmarks) {
                        listener.onSuccess(maptexBookmarks);
                    }
                });


    }

    public void deleteBookmark(String token, final String id, final ResponseListener<MaptexSimpleNetworkEntity> listener) {
        repository.deleteBookmark(token, id).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexSimpleNetworkEntity maptexTags) {
                        listener.onSuccess(maptexTags);
                    }
                });
    }

    public void getRouteInfo(MaptexLatLng startPosition, MaptexLatLng endPosition, RouteMode routeMode,
                             final ResponseListener<MaptexRouteResponse> listener) {

        repository.getRouteInfo(startPosition, endPosition, routeMode).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexRouteResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MaptexRouteResponse maptexRouteInfo) {
                        listener.onSuccess(maptexRouteInfo);
                    }
                });
    }

    public void getStaticMap(double latitude, double longitude, int zoom, final ResponseListener<Bitmap> listener) {

        repository.getStaticMap(latitude, longitude, zoom).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<Bitmap>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MaptexError(e.getMessage()));
                    }

                    @Override
                    public void onNext(Bitmap bitmap) {
                        listener.onSuccess(bitmap);
                    }
                });
    }

    public void sendFeedback(RequestBody body,
                             final ResponseListener<MaptexNetworkEntity> listener) {
        repository.sendFeedback(body).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(MaptexNetworkEntity maptexNetworkEntity) {
                        listener.onSuccess(maptexNetworkEntity);
                    }
                });
    }

    public void signupUser(MaptexAuthenticate authenticate, final ResponseListener<MaptexAuthenticateResponse> listener) {
        String params = new Gson().toJson(authenticate);
        repository.signupUser(params).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexAuthenticateResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(MaptexAuthenticateResponse maptexLoginResponse) {
                        listener.onSuccess(maptexLoginResponse);
                    }
                });
    }

    public void verifyUser(String code, String phoneNumber, final ResponseListener<MaptexAuthenticateResponse> listener) {
        String params = "/" + phoneNumber + "/" + code;
        repository.verifyUser(params).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexAuthenticateResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(MaptexAuthenticateResponse maptexLoginResponse) {

                        listener.onSuccess(maptexLoginResponse);
                    }
                });
    }

    public void resendVerificationCode(String phoneNumber, final ResponseListener<MaptexResendVerification> listener) {
        String params = "/" + phoneNumber;
        repository.resendVerificationCode(params).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexResendVerification>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(MaptexResendVerification maptexResendVerification) {
                        listener.onSuccess(maptexResendVerification);
                    }
                });
    }

    private void loginUser(final LoginResponse loginResponse) {
        MaptexLogin login = new MaptexLogin();
        login.user = "hani";
        login.pass = "123456789";
        String loginParams = new Gson().toJson(login);
        repository.loginUser(loginParams).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexLoginResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        loginResponse.loginUserFailed(message);
                    }

                    @Override
                    public void onNext(MaptexLoginResponse maptexLoginResponse) {

                        loginResponse.loginUserSuccessful();
                    }
                });
    }

    public void loginUser(MaptexLogin login, final ResponseListener<MaptexLoginResponse> loginResponse) {
        String loginParams = new Gson().toJson(login);
        repository.loginUser(loginParams).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexLoginResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        loginResponse.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(MaptexLoginResponse maptexLoginResponse) {

                        loginResponse.onSuccess(maptexLoginResponse);
                    }
                });
    }

    public void forgetPassword(String username, final ResponseListener<MaptexForgotEntity> loginResponse) {
        repository.forgetPassword(username).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexForgotEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        loginResponse.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(MaptexForgotEntity message) {
                        loginResponse.onSuccess(message);
                    }
                });
    }

    public void loginUserByGmail(String token, final ResponseListener<MaptexLoginResponse> responseListener) {
        repository.loginUserByGmail(token).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexLoginResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        responseListener.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(MaptexLoginResponse maptexLoginResponse) {

                        responseListener.onSuccess(maptexLoginResponse);
                    }
                });
    }

    public void signoutUser(String token, final ResponseListener<MaptexSimpleNetworkEntity> listener) {
        repository.signoutUser(token).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(MaptexSimpleNetworkEntity maptexLoginResponse) {

                        listener.onSuccess(maptexLoginResponse);
                    }
                });
    }

    public void getTag(String token, String tagId, final ResponseListener<MaptexTag> listener) {
        repository.getTag(token, tagId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<List<MaptexTag>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(List<MaptexTag> maptexTag) {

                        listener.onSuccess(maptexTag.get(0));
                    }
                });
    }

    public void getProfile(String userName, String token, final ResponseListener<MaptexProfileResponse> listener) {
        repository.getProfile(userName, token).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexProfileResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(MaptexProfileResponse profileResponses) {

                        listener.onSuccess(profileResponses);
                    }
                });
    }

    public void updateProfile(String userName, String token, String nickname, String phone,
                              String mail, String address, final ResponseListener<MaptexProfileResponse> listener) {
        MaptexProfile profile = new MaptexProfile();
        MaptexProfile.ProfileData data = new MaptexProfile.ProfileData();
        data.nickname = new String[]{nickname};
        data.phone = new String[]{phone};
        data.email = new String[]{mail};
        data.address = new String[]{address};
        profile.data = data;

        String profileJson = new Gson().toJson(profile);

        repository.updateProfile(userName, token, profileJson).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MaptexProfileResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MaptexError(message));
                    }

                    @Override
                    public void onNext(MaptexProfileResponse profileResponses) {

                        listener.onSuccess(profileResponses);
                    }
                });

    }

    public interface LoginResponse {
        void loginUserSuccessful();

        void loginUserFailed(String error);
    }
}
