package ir.map.sdk_map.utils;

import android.content.Context;
import android.os.Bundle;

import ir.map.sdk_map.constants.MapirConstants;
import ir.map.sdk_map.maps.MapirMapOptions;

/**
 * MapFragment utility class.
 * <p>
 * Used to extract duplicate code between {@link ir.map.sdk_map.maps.MapFragment} and
 * {@link ir.map.sdk_map.maps.SupportMapFragment}.
 * </p>
 */
public class MapFragmentUtils {

  /**
   * Convert MapirMapOptions to a bundle of fragment arguments.
   *
   * @param options The MapirMapOptions to convert
   * @return a bundle of converted fragment arguments
   */
  public static Bundle createFragmentArgs(MapirMapOptions options) {
    Bundle bundle = new Bundle();
    bundle.putParcelable(MapirConstants.FRAG_ARG_MAPIRMAPOPTIONS, options);
    return bundle;
  }

  /**
   * Convert a bundle of fragment arguments to MapirMapOptions.
   *
   * @param context The context of the activity hosting the fragment
   * @param args    The fragment arguments
   * @return converted MapirMapOptions
   */
  public static MapirMapOptions resolveArgs(Context context, Bundle args) {
    MapirMapOptions options;
    if (args != null && args.containsKey(MapirConstants.FRAG_ARG_MAPIRMAPOPTIONS)) {
      options = args.getParcelable(MapirConstants.FRAG_ARG_MAPIRMAPOPTIONS);
    } else {
      // load default options
      options = MapirMapOptions.createFromAttributes(context, null);
    }
    return options;
  }
}
