package ir.map.sdk_map.maps;


import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.List;

import ir.map.sdk_map.annotations.BaseMarkerOptions;
import ir.map.sdk_map.annotations.BaseMarkerViewOptions;
import ir.map.sdk_map.annotations.Marker;
import ir.map.sdk_map.annotations.MarkerView;
import ir.map.sdk_map.annotations.MarkerViewManager;

/**
 * Interface that defines convenient methods for working with a {@link Marker}'s collection.
 */
interface Markers {
  Marker addBy(@NonNull BaseMarkerOptions markerOptions, @NonNull MapirMap mapirMap);

  List<Marker> addBy(@NonNull List<? extends BaseMarkerOptions> markerOptionsList, @NonNull MapirMap mapirMap);

  void update(@NonNull Marker updatedMarker, @NonNull MapirMap mapirMap);

  List<Marker> obtainAll();

  List<Marker> obtainAllIn(@NonNull RectF rectangle);

  MarkerView addViewBy(@NonNull BaseMarkerViewOptions markerOptions, @NonNull MapirMap mapirMap,
                       @Nullable MarkerViewManager.OnMarkerViewAddedListener onMarkerViewAddedListener);

  List<MarkerView> addViewsBy(@NonNull List<? extends BaseMarkerViewOptions> markerViewOptions,
                              @NonNull MapirMap mapirMap);

  List<MarkerView> obtainViewsIn(@NonNull RectF rectangle);

  void reload();
}
