package ir.map.sdk_map.location;

import android.animation.ValueAnimator;
import android.support.annotation.Nullable;

import java.util.List;

import ir.map.sdk_map.maps.MapirMap;

class TiltAnimator extends MapirCameraAnimatorAdapter {
  TiltAnimator(Float previous, Float target, List<OnCameraAnimationsValuesChangeListener> updateListeners,
               @Nullable MapirMap.CancelableCallback cancelableCallback) {
    super(previous, target, updateListeners, cancelableCallback);
  }

  @Override
  int provideAnimatorType() {
    return ANIMATOR_TILT;
  }

  @Override
  public void onAnimationUpdate(ValueAnimator animation) {
    for (OnCameraAnimationsValuesChangeListener listener : updateListeners) {
      listener.onNewTiltValue((Float) animation.getAnimatedValue());
    }
  }
}
