package ir.map.sdk_map.location;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.support.annotation.Nullable;

import java.util.List;

import ir.map.sdk_map.maps.MapirMap;

abstract class MapirCameraAnimatorAdapter extends
  MapirFloatAnimator<MapirAnimator.OnCameraAnimationsValuesChangeListener> {
  private final MapirMap.CancelableCallback cancelableCallback;

  MapirCameraAnimatorAdapter(Float previous, Float target,
                             List<OnCameraAnimationsValuesChangeListener> updateListeners,
                             @Nullable MapirMap.CancelableCallback cancelableCallback) {
    super(previous, target, updateListeners);
    this.cancelableCallback = cancelableCallback;
    addListener(new MapboxAnimatorListener());
  }

  private final class MapboxAnimatorListener extends AnimatorListenerAdapter {
    @Override
    public void onAnimationCancel(Animator animation) {
      if (cancelableCallback != null) {
        cancelableCallback.onCancel();
      }
    }

    @Override
    public void onAnimationEnd(Animator animation) {
      if (cancelableCallback != null) {
        cancelableCallback.onFinish();
      }
    }
  }
}
