package ir.map.sdk_map.location;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.support.annotation.NonNull;
import android.view.animation.Interpolator;

import java.util.List;

class MapirAnimatorSetProvider {
  private static MapirAnimatorSetProvider instance;

  private MapirAnimatorSetProvider() {
    // private constructor
  }

  static MapirAnimatorSetProvider getInstance() {
    if (instance == null) {
      instance = new MapirAnimatorSetProvider();
    }
    return instance;
  }

  void startAnimation(@NonNull List<Animator> animators, @NonNull Interpolator interpolator,
                      long duration) {
    AnimatorSet locationAnimatorSet = new AnimatorSet();
    locationAnimatorSet.playTogether(animators);
    locationAnimatorSet.setInterpolator(interpolator);
    locationAnimatorSet.setDuration(duration);
    locationAnimatorSet.start();
  }
}
