package ir.map.sdk_map.location;

import android.animation.ValueAnimator;

import java.util.List;

import ir.map.sdk_map.geometry.LatLng;

class LayerLatLngAnimator extends MapirLatLngAnimator<MapirAnimator.OnLayerAnimationsValuesChangeListener> {
  LayerLatLngAnimator(LatLng previous, LatLng target, List<OnLayerAnimationsValuesChangeListener> updateListeners) {
    super(previous, target, updateListeners);
  }

  @Override
  int provideAnimatorType() {
    return ANIMATOR_LAYER_LATLNG;
  }

  @Override
  public void onAnimationUpdate(ValueAnimator animation) {
    for (OnLayerAnimationsValuesChangeListener listener : updateListeners) {
      listener.onNewLatLngValue((LatLng) animation.getAnimatedValue());
    }
  }
}
