package ir.map.sdk_map.location;

import android.animation.ValueAnimator;

import java.util.List;

import ir.map.sdk_map.geometry.LatLng;

class CameraLatLngAnimator extends MapirLatLngAnimator<MapirAnimator.OnCameraAnimationsValuesChangeListener> {
  CameraLatLngAnimator(LatLng previous, LatLng target, List<OnCameraAnimationsValuesChangeListener> updateListeners) {
    super(previous, target, updateListeners);
  }

  @Override
  int provideAnimatorType() {
    return ANIMATOR_CAMERA_LATLNG;
  }

  @Override
  public void onAnimationUpdate(ValueAnimator animation) {
    for (OnCameraAnimationsValuesChangeListener listener : updateListeners) {
      listener.onNewLatLngValue((LatLng) animation.getAnimatedValue());
    }
  }
}
