package ir.map.sdk_map.exceptions;

import android.content.Context;

import ir.map.sdk_map.Mapir;

/**
 * A MapirConfigurationException is thrown by MapirMap when the SDK hasn't been properly initialised.
 * <p>
 * This occurs either when {@link Mapir} is not correctly initialised or the provided access token
 * through {@link Mapir#getInstance(Context, String)} isn't valid.
 * </p>
 *
 * @see Mapir#getInstance(Context, String)
 */
public class MapirConfigurationException extends RuntimeException {

  /**
   * Creates a Mapir configuration exception thrown by MapirMap when the SDK hasn't been properly initialised.
   */
  public MapirConfigurationException() {
    super("\nUsing MapView requires calling Mapir.getInstance(Context context, String accessToken) before "
      + "inflating or creating the view. The access token parameter is required when using a Mapir service."
      + "\nPlease see https://www.mapbox.com/help/create-api-access-token/ to learn how to create one."
      + "\nMore information in this guide https://www.mapbox.com/help/first-steps-android-sdk/#access-tokens.");
  }
}
