package ir.map.sdk_map.constants;

import android.support.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import ir.map.sdk_map.maps.MapView;

/**
 * <p>
 * Style provides URLs to several professional styles designed by Mapir.
 * </p>
 * These styles are all ready to go in your app. To load one, pass it into {@link MapView#setStyleUrl(String)}
 *
 * @see MapView#setStyleUrl(String)
 */
public class Style {

  /**
   * Mapir Raster: A complete basemap, perfect for incorporating your own data. Using this
   * constant means your map style will always use the raster version
   */
  public static final String MAPIR_RASTER = "asset://shiveh.json";

  //TODO haniyeh
  public static final String DEV_MAPIR_VECTOR = "https://dev.map.ir/vector/styles/main/main_mobile_style.json";

  //TODO Ali
  public static final String MAPIR_VECTOR = "https://map.ir/vector/styles/main/main_mobile_style.json";
  /**
   * Indicates the parameter accepts one of the values from Style. Using one of these
   * constants means your map style will always use the latest version and may change as we
   * improve the style
   */
  @StringDef( {MAPIR_RASTER, DEV_MAPIR_VECTOR, MAPIR_VECTOR})
  @Retention(RetentionPolicy.SOURCE)
  public @interface StyleUrl {
  }

}
