package ir.map.sdk_map.annotations;

import android.graphics.Color;
import android.support.annotation.Keep;

import ir.map.sdk_map.maps.MapirMap;

/**
 * Polyline is a geometry feature with an unclosed list of coordinates drawn as a line
 */
public final class Polyline extends BasePointCollection {

  @Keep
  private int color = Color.BLACK; // default color is black
  @Keep
  private float width = 10; // As specified by Google API Docs (in pixels)

  Polyline() {
    super();
  }

  /**
   * Gets the color of this polyline.
   *
   * @return The color in ARGB format.
   */
  public int getColor() {
    return color;
  }

  /**
   * Sets the color of the polyline.
   *
   * @param color - the color in ARGB format
   */
  public void setColor(int color) {
    this.color = color;
    update();
  }

  /**
   * Gets the width of this polyline.
   *
   * @return The width in screen pixels.
   */
  public float getWidth() {
    return width;
  }

  /**
   * Sets the width of the polyline.
   *
   * @param width in pixels
   */
  public void setWidth(float width) {
    this.width = width;
    update();
  }

  @Override
  void update() {
    MapirMap mapirMap = getMapirMap();
    if (mapirMap != null) {
      mapirMap.updatePolyline(this);
    }
  }
}
