package ir.map.sdk_map.wrapper;

import android.util.Log;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

/**
 * Created by haniyeh on 12/11/17.
 */

public class TileProviderHelper {

    private String SHIVEH_BASE_URL = "https://world.map.ir/";
    private String OSGEO_WMS = SHIVEH_BASE_URL + "shiveh?" +
            "service=WMS" +
            "&version=1.1.0" +
            "&EXCEPTIONS=application/vnd.ogc.se_inimage" +
            "&request=GetMap" +
            "&layers=Shiveh:Shiveh" +
            "&width=256" +
            "&height=256" +
            "&srs=EPSG:3857" +
            "&format=image/png" +
            "&bbox=%f,%f,%f,%f";

    // array indexes for array to hold bounding boxes.
    private int MINX = 0;
    private int MAXX = 1;
    private int MINY = 2;
    private int MAXY = 3;
    private double[] TILE_ORIGIN = new double[]{-20037508.34789244, 20037508.34789244};
    // array indexes for that data
    private int ORIG_X = 0;
    private int ORIG_Y = 1; // "
    // Size of square world map in meters, using WebMerc projection.
    private double MAP_SIZE = 20037508.34789244 * 2;

    public URL getTileUrl(int x, int y, int zoom) {
        Double[] bbox = getBoundingBox(x, y, zoom);
        String s = String.format(Locale.US, OSGEO_WMS, bbox[MINX], bbox[MINY], bbox[MAXX], bbox[MAXY]);
        Log.d("WMSDEMO", s);
        URL url;
        try {
            url = new URL(s);
        } catch (MalformedURLException e) {
            throw new AssertionError(e);
        }
        return url;
    }

    private Double[] getBoundingBox(int x, int y, int zoom) {

        double tileSize = MAP_SIZE / Math.pow(2.0, (double) zoom);
        double minx = TILE_ORIGIN[ORIG_X] + x * tileSize;
        double maxx = TILE_ORIGIN[ORIG_X] + (x + 1) * tileSize;
        double miny = TILE_ORIGIN[ORIG_Y] - (y + 1) * tileSize;
        double maxy = TILE_ORIGIN[ORIG_Y] - y * tileSize;

        Double[] bbox = new Double[4];
        bbox[MINX] = minx;
        bbox[MINY] = miny;
        bbox[MAXX] = maxx;
        bbox[MAXY] = maxy;

        return bbox;
    }
}
