package ir.map.sdk_map.wrapper;

import com.google.android.gms.maps.model.PatternItem;

import java.util.ArrayList;
import java.util.List;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.internal.ListTranslators;
import ir.map.sdk_map.internal.ListWrappers;


public final class MaptexPolyline {

    final com.google.android.gms.maps.model.Polyline mOriginal;

    private MaptexPolyline(com.google.android.gms.maps.model.Polyline original) {
        mOriginal = original;
    }

    /**
     * Obtain a new MaptexPolyline based an original one.
     *
     * @param original
     * @return

     */
    public static MaptexPolyline obtain(com.google.android.gms.maps.model.Polyline original) {
        return new MaptexPolyline(original);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaptexPolyline)) {
            return false;
        }
        return mOriginal.equals(((MaptexPolyline) other).mOriginal);
    }

    @Override
    public int hashCode() {
        return mOriginal.hashCode();
    }

    public int getColor() {
        return mOriginal.getColor();
    }

    public void setColor(int color) {
        mOriginal.setColor(color);
    }

    public String getId() {
        return mOriginal.getId();
    }

    public List<MaptexLatLng> getPoints() {
        final List<com.google.android.gms.maps.model.LatLng> original = mOriginal.getPoints();
        return original == null ? null : ListWrappers.forLatLng(original);
    }

    public void setPoints(List<MaptexLatLng> points) {
        mOriginal.setPoints(points == null ? null : ListTranslators.latLngList(points));
    }

    public float getWidth() {
        return mOriginal.getWidth();
    }

    public void setWidth(float width) {
        mOriginal.setWidth(width);
    }

    public float getZIndex() {
        return mOriginal.getZIndex();
    }

    public void setZIndex(float zIndex) {
        mOriginal.setZIndex(zIndex);
    }

    public boolean isGeodesic() {
        return mOriginal.isGeodesic();
    }

    public void setGeodesic(boolean geodesic) {
        mOriginal.setGeodesic(geodesic);
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    public void setVisible(boolean visible) {
        mOriginal.setVisible(visible);
    }

    public void remove() {
        mOriginal.remove();
    }

    public void setStartCap(MaptexRoundCap cap) {
        mOriginal.setStartCap(cap);
    }

    public void setEndCap(MaptexRoundCap cap) {
        mOriginal.setEndCap(cap);
    }

    public void setPattern(List<MaptexPatternItem> maptexPatternItems) {
        List<PatternItem> patternItems = new ArrayList<>();
        for (MaptexPatternItem item : maptexPatternItems) {
            patternItems.add(item.mOriginal);
        }
        mOriginal.setPattern(patternItems);
    }

    public boolean isClickable() {
        return mOriginal.isClickable();
    }

    public void setClickable(boolean clickable) {
        mOriginal.setClickable(clickable);
    }

    public Object getTag() {
        return mOriginal.getTag();
    }

    public void setTag(Object alternative) {
        mOriginal.setTag(alternative);
    }
}
