package ir.map.sdk_map.wrapper;

import android.view.View;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * @author haniyeh
 */

public class MaptexMarkerManager {
    private final Map<String, Collection> mNamedCollections = new HashMap();
    private final Map<MaptexMarker, Collection> mAllMarkers = new HashMap();
    private MaptexMap maptexMap;

    public MaptexMarkerManager(MaptexMap maptexMap) {
        this.maptexMap = maptexMap;
    }

    public Collection newCollection() {
        return new Collection();
    }

    public Collection newCollection(String id) {
        if (this.mNamedCollections.get(id) != null) {
            throw new IllegalArgumentException("collection id is not unique: " + id);
        } else {
            Collection collection = new Collection();
            this.mNamedCollections.put(id, collection);
            return collection;
        }
    }

    public Collection getCollection(String id) {
        return (Collection) this.mNamedCollections.get(id);
    }

    public View getInfoWindow(MaptexMarker marker) {
        Collection collection = (Collection) this.mAllMarkers.get(marker);
        return collection != null && collection.mInfoWindowAdapter != null ? collection.mInfoWindowAdapter.getInfoWindow(marker) : null;
    }

    public View getInfoContents(MaptexMarker marker) {
        Collection collection = (Collection) this.mAllMarkers.get(marker);
        return collection != null && collection.mInfoWindowAdapter != null ? collection.mInfoWindowAdapter.getInfoContents(marker) : null;
    }

    public void onInfoWindowClick(MaptexMarker marker) {
        Collection collection = (Collection) this.mAllMarkers.get(marker);
        if (collection != null && collection.mInfoWindowClickListener != null) {
            collection.mInfoWindowClickListener.onInfoWindowClick(marker);
        }

    }

    public boolean onMarkerClick(MaptexMarker marker) {
        Collection collection = (Collection) this.mAllMarkers.get(marker);
        return collection != null && collection.mMarkerClickListener != null ? collection.mMarkerClickListener.onMarkerClick(marker) : false;
    }

    public void onMarkerDragStart(MaptexMarker marker) {
        Collection collection = (Collection) this.mAllMarkers.get(marker);
        if (collection != null && collection.mMarkerDragListener != null) {
            collection.mMarkerDragListener.onMarkerDragStart(marker);
        }

    }

    public void onMarkerDrag(MaptexMarker marker) {
        Collection collection = (Collection) this.mAllMarkers.get(marker);
        if (collection != null && collection.mMarkerDragListener != null) {
            collection.mMarkerDragListener.onMarkerDrag(marker);
        }

    }

    public void onMarkerDragEnd(MaptexMarker marker) {
        Collection collection = (Collection) this.mAllMarkers.get(marker);
        if (collection != null && collection.mMarkerDragListener != null) {
            collection.mMarkerDragListener.onMarkerDragEnd(marker);
        }

    }

    public boolean remove(MaptexMarker marker) {
        Collection collection = (Collection) this.mAllMarkers.get(marker);
        return collection != null && collection.remove(marker);
    }

    public class Collection {
        private final Set<MaptexMarker> mMarkers = new HashSet();
        private MaptexMap.OnInfoWindowClickListener mInfoWindowClickListener;
        private MaptexMap.OnMarkerClickListener mMarkerClickListener;
        private MaptexMap.OnMarkerDragListener mMarkerDragListener;
        private MaptexMap.InfoWindowAdapter mInfoWindowAdapter;

        public Collection() {
        }

        public MaptexMarker addMarker(MaptexMarkerOptions opts) {
            MaptexMarker marker = MaptexMarkerManager.this.maptexMap.addMarker(opts);
            this.mMarkers.add(marker);
            MaptexMarkerManager.this.mAllMarkers.put(marker, this);
            return marker;
        }

        public boolean remove(MaptexMarker marker) {
            if (this.mMarkers.remove(marker)) {
                MaptexMarkerManager.this.mAllMarkers.remove(marker);
                marker.remove();
                return true;
            } else {
                return false;
            }
        }

        public void clear() {
            Iterator var1 = this.mMarkers.iterator();

            while (var1.hasNext()) {
                MaptexMarker marker = (MaptexMarker) var1.next();
                marker.remove();
                MaptexMarkerManager.this.mAllMarkers.remove(marker);
            }

            this.mMarkers.clear();
        }

        public java.util.Collection<MaptexMarker> getMarkers() {
            return Collections.unmodifiableCollection(this.mMarkers);
        }

        public void setOnInfoWindowClickListener(MaptexMap.OnInfoWindowClickListener infoWindowClickListener) {
            this.mInfoWindowClickListener = infoWindowClickListener;
        }

        public void setOnMarkerClickListener(MaptexMap.OnMarkerClickListener markerClickListener) {
            this.mMarkerClickListener = markerClickListener;
        }

        public void setOnMarkerDragListener(MaptexMap.OnMarkerDragListener markerDragListener) {
            this.mMarkerDragListener = markerDragListener;
        }

        public void setOnInfoWindowAdapter(MaptexMap.InfoWindowAdapter infoWindowAdapter) {
            this.mInfoWindowAdapter = infoWindowAdapter;
        }
    }
}
