package ir.map.sdk_map.wrapper;

import android.graphics.Bitmap;
import android.location.Location;
import android.support.annotation.RequiresPermission;
import android.view.View;

import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.UrlTileProvider;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;

import java.io.ByteArrayOutputStream;
import java.net.URL;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.MapSDK;


public final class MaptexMap {

    //    public static final int MAP_TYPE_HYBRID = com.google.android.gms.maps.GoogleMap.MAP_TYPE_HYBRID;
    public static final int MAP_TYPE_NONE = com.google.android.gms.maps.GoogleMap.MAP_TYPE_NONE;
    public static final int MAP_TYPE_NORMAL = com.google.android.gms.maps.GoogleMap.MAP_TYPE_NORMAL;
    //    public static final int MAP_TYPE_SATELLITE = com.google.android.gms.maps.GoogleMap.MAP_TYPE_SATELLITE;
//    public static final int MAP_TYPE_TERRAIN = com.google.android.gms.maps.GoogleMap.MAP_TYPE_TERRAIN;
    final com.google.android.gms.maps.GoogleMap mOriginal;

    MaptexMap(com.google.android.gms.maps.GoogleMap original) {
        mOriginal = original;
        mOriginal.setMapType(MaptexMap.MAP_TYPE_NONE);
        BaseMaptexUrlTileProvider tileProvider = getCachingTile();
        mOriginal.addTileOverlay(new MaptexTileOverlayOptions().tileProvider(tileProvider).mOriginal);

        mOriginal.getUiSettings().setMapToolbarEnabled(false);
        mOriginal.getUiSettings().setMyLocationButtonEnabled(false);
        mOriginal.getUiSettings().setCompassEnabled(false);
        mOriginal.getUiSettings().setZoomControlsEnabled(false);
    }

    private BaseMaptexUrlTileProvider getCachingTile() {
        if (ImageLoader.getInstance().isInited())
            ImageLoader.getInstance().destroy();
        ImageLoaderConfiguration config = new ImageLoaderConfiguration.Builder(MapSDK.getContext())
                .imageDownloader(new MapirImageDownloader(MapSDK.getContext()))
                .build();
        ImageLoader.getInstance().init(config);
        final ImageLoader imageLoader = ImageLoader.getInstance();
        final DisplayImageOptions mOptions;

        // init ImageLoader display options
        DisplayImageOptions.Builder builder = new DisplayImageOptions.Builder();
        builder.cacheInMemory(true).cacheOnDisk(true);
        mOptions = builder.build();

        return new BaseMaptexUrlTileProvider(256, 256) {
            @Override
            public synchronized URL getTileUrl(int x, int y, int zoom) {
                return new TileProviderHelper().getTileUrl(x, y, zoom);
            }

            @Override
            public MaptexTile getTile(int x, int y, int zoom) {
                byte[] tileImage = getTileImage(x, y, zoom);
                if (tileImage != null) {
                    return new MaptexTile(256, 256, tileImage);
                } else return MaptexTileProvider.NO_MAPTEX_TILE;
            }

            private byte[] getTileImage(int x, int y, int zoom) {
                Bitmap bitmap = imageLoader.loadImageSync(getTileUrl(x, y, zoom).toString(), mOptions);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
                return stream.toByteArray();
            }
        };
    }

    public final MaptexCircle addCircle(MaptexCircleOptions options) {
        final com.google.android.gms.maps.model.Circle original = mOriginal.addCircle(options.mOriginal);
        original.setZIndex(4);
        return original == null ? null : MaptexCircle.obtain(original);
    }

    public final MaptexGroundOverlay addGroundOverlay(MaptexGroundOverlayOptions options) {
        final com.google.android.gms.maps.model.GroundOverlay original = mOriginal.addGroundOverlay(options.mOriginal);
        original.setZIndex(4);
        return original == null ? null : MaptexGroundOverlay.obtain(original);
    }

    public MaptexMarker addMarker(MaptexMarkerOptions options) {
        final com.google.android.gms.maps.model.Marker original = mOriginal.addMarker(options.mOriginal);
        return original == null ? null : MaptexMarker.obtain(original);
    }

    public final MaptexPolygon addPolygon(MaptexPolygonOptions options) {
        final com.google.android.gms.maps.model.Polygon original = mOriginal.addPolygon(options.mOriginal);
        original.setZIndex(4);
        return original == null ? null : MaptexPolygon.obtain(original);
    }

    public final MaptexPolyline addPolyline(MaptexPolylineOptions options) {
        final com.google.android.gms.maps.model.Polyline original = mOriginal.addPolyline(options.mOriginal);
        original.setZIndex(4);
        return original == null ? null : MaptexPolyline.obtain(original);
    }

    public final MaptexTileOverlay addTileOverlay(MaptexTileOverlayOptions options) {
        final com.google.android.gms.maps.model.TileOverlay original = mOriginal.addTileOverlay(options.mOriginal);
        return original == null ? null : MaptexTileOverlay.obtain(original);
    }

    public void animateCamera(MaptexCameraUpdate update) {
        mOriginal.animateCamera(update.mOriginal);
    }

    public void animateCamera(MaptexCameraUpdate update, CancelableCallback callback) {
        final CancelableCallback fCallback = callback;
        mOriginal.animateCamera(update.mOriginal, callback == null ? null : new com.google.android.gms.maps.GoogleMap.CancelableCallback() {
            @Override
            public void onFinish() {
                fCallback.onFinish();
            }

            @Override
            public void onCancel() {
                fCallback.onCancel();
            }
        });
    }

    public void animateCamera(MaptexCameraUpdate update, int durationMs, CancelableCallback callback) {
        final CancelableCallback fCallback = callback;
        mOriginal.animateCamera(update.mOriginal, durationMs,
                callback == null ? null : new com.google.android.gms.maps.GoogleMap.CancelableCallback() {
                    @Override
                    public void onFinish() {
                        fCallback.onFinish();
                    }

                    @Override
                    public void onCancel() {
                        fCallback.onCancel();
                    }
                });
    }

    public void clear() {
        mOriginal.clear();
        UrlTileProvider tileProvider = getCachingTile().mOriginal;
        mOriginal.addTileOverlay(new TileOverlayOptions().tileProvider(tileProvider));
    }

    public MaptexCameraPosition getCameraPosition() {
        final com.google.android.gms.maps.model.CameraPosition original = mOriginal.getCameraPosition();
        return original == null ? null : MaptexCameraPosition.obtain(original);
    }

    public int getMapType() {
        return mOriginal.getMapType();
    }

    public void setMapType(int type) {
        mOriginal.setMapType(type);
    }

//    public float getMaxZoomLevel() {
//        return mOriginal.getMaxZoomLevel();
//    }
//
//    public float getMinZoomLevel() {
//        return mOriginal.getMinZoomLevel();
//    }

    public Location getMyLocation() {
        return mOriginal.getMyLocation();
    }

    public MaptexProjection getProjection() {
        final com.google.android.gms.maps.Projection original = mOriginal.getProjection();
        return original == null ? null : new MaptexProjection(original);
    }

    public MaptexUiSettings getUiSettings() {
        final com.google.android.gms.maps.UiSettings original = mOriginal.getUiSettings();
        return original == null ? null : new MaptexUiSettings(original);
    }

//    public boolean isIndoorEnabled() {
//        return mOriginal.isIndoorEnabled();
//    }

    public boolean isMyLocationEnabled() {
        return mOriginal.isMyLocationEnabled();
    }

    @RequiresPermission(
            anyOf = {"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"}
    )
    public void setMyLocationEnabled(boolean enabled) {
        mOriginal.setMyLocationEnabled(enabled);
    }

//    public boolean isTrafficEnabled() {
//        return mOriginal.isTrafficEnabled();
//    }
//
//    public void setTrafficEnabled(boolean enabled) {
//        mOriginal.setTrafficEnabled(enabled);
//    }

    public void moveCamera(MaptexCameraUpdate update) {
        mOriginal.moveCamera(update.mOriginal);
    }

    public boolean setIndoorEnabled(boolean enabled) {
        return mOriginal.setIndoorEnabled(enabled);
    }

    public void setLocationSource(MaptexLocationSource source) {
        final MaptexLocationSource fSource = source;
        mOriginal.setLocationSource(fSource == null ? null : new com.google.android.gms.maps.LocationSource() {
            @Override
            public void activate(final com.google.android.gms.maps.LocationSource.OnLocationChangedListener listener) {
                fSource.activate(new MaptexLocationSource.OnLocationChangedListener() {
                    @Override
                    public void onLocationChanged(final Location location) {
                        listener.onLocationChanged(location);
                    }
                });
            }

            @Override
            public void deactivate() {
                fSource.deactivate();
            }
        });
    }

    public void setOnCameraChangeListener(OnCameraChangeListener listener) {
        final OnCameraChangeListener fListener = listener;
        mOriginal.setOnCameraChangeListener(fListener == null ? null : new com.google.android.gms.maps.GoogleMap.OnCameraChangeListener() {
            @Override
            public void onCameraChange(com.google.android.gms.maps.model.CameraPosition position) {
                fListener.onCameraChange(MaptexCameraPosition.obtain(position));
            }
        });
    }

    public final void setOnCameraMoveStartedListener(OnCameraMoveStartedListener listener) {
        final OnCameraMoveStartedListener fListener = listener;
        mOriginal.setOnCameraMoveStartedListener(fListener == null ? null : new com.google.android.gms.maps.GoogleMap.OnCameraMoveStartedListener() {
            @Override
            public void onCameraMoveStarted(int i) {
                fListener.onCameraMoveStarted(i);
            }
        });
    }


    public void setOnMapClickListener(OnMapClickListener listener) {
        final OnMapClickListener fListener = listener;
        mOriginal.setOnMapClickListener(fListener == null ? null : new com.google.android.gms.maps.GoogleMap.OnMapClickListener() {
            @Override
            public void onMapClick(com.google.android.gms.maps.model.LatLng point) {
                fListener.onMapClick(new MaptexLatLng(point.latitude, point.longitude));
            }
        });
    }

    public void setOnPolylineClickListener(final OnPolylineClickListener listener) {
        final OnPolylineClickListener fListener = listener;
        mOriginal.setOnPolylineClickListener(fListener == null ? null : new com.google.android.gms.maps.GoogleMap.OnPolylineClickListener() {

            @Override
            public void onPolylineClick(Polyline polyline) {
                listener.onPolylineClick(MaptexPolyline.obtain(polyline));
            }
        });
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener listener) {
        final OnMapLongClickListener fListener = listener;
        mOriginal.setOnMapLongClickListener(fListener == null ? null : new com.google.android.gms.maps.GoogleMap.OnMapLongClickListener() {
            @Override
            public void onMapLongClick(com.google.android.gms.maps.model.LatLng point) {
                fListener.onMapLongClick(new MaptexLatLng(point.latitude, point.longitude));
            }
        });
    }

    public void setOnMarkerClickListener(OnMarkerClickListener listener) {
        final OnMarkerClickListener fListener = listener;
        mOriginal.setOnMarkerClickListener(fListener == null ? null : new com.google.android.gms.maps.GoogleMap.OnMarkerClickListener() {
            @Override
            public boolean onMarkerClick(com.google.android.gms.maps.model.Marker marker) {
                return fListener.onMarkerClick(MaptexMarker.obtain(marker));
            }
        });
    }

    public final void setInfoWindowAdapter(InfoWindowAdapter adapter) {
        final InfoWindowAdapter fAdapter = adapter;
        mOriginal.setInfoWindowAdapter(fAdapter == null ? null : new com.google.android.gms.maps.GoogleMap.InfoWindowAdapter() {
            @Override
            public View getInfoWindow(com.google.android.gms.maps.model.Marker marker) {
                return fAdapter.getInfoWindow(MaptexMarker.obtain(marker));
            }

            @Override
            public View getInfoContents(com.google.android.gms.maps.model.Marker marker) {
                return fAdapter.getInfoContents(MaptexMarker.obtain(marker));
            }
        });
    }

    public final void setOnInfoWindowClickListener(OnInfoWindowClickListener listener) {
        final OnInfoWindowClickListener fListener = listener;
        mOriginal.setOnInfoWindowClickListener(
                fListener == null ? null : new com.google.android.gms.maps.GoogleMap.OnInfoWindowClickListener() {
                    @Override
                    public void onInfoWindowClick(com.google.android.gms.maps.model.Marker marker) {
                        fListener.onInfoWindowClick(MaptexMarker.obtain(marker));
                    }
                });
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener listener) {
        final OnMarkerDragListener fListener = listener;
        mOriginal.setOnMarkerDragListener(fListener == null ? null : new com.google.android.gms.maps.GoogleMap.OnMarkerDragListener() {

            @Override
            public void onMarkerDrag(com.google.android.gms.maps.model.Marker marker) {
                fListener.onMarkerDrag(MaptexMarker.obtain(marker));
            }

            @Override
            public void onMarkerDragEnd(com.google.android.gms.maps.model.Marker marker) {
                fListener.onMarkerDragEnd(MaptexMarker.obtain(marker));
            }

            @Override
            public void onMarkerDragStart(com.google.android.gms.maps.model.Marker marker) {
                fListener.onMarkerDragStart(MaptexMarker.obtain(marker));
            }
        });
    }

    public final void setOnMyLocationChangeListener(OnMyLocationChangeListener listener) {
        final OnMyLocationChangeListener fListener = listener;
        mOriginal.setOnMyLocationChangeListener(
                fListener == null ? null : new com.google.android.gms.maps.GoogleMap.OnMyLocationChangeListener() {
                    @Override
                    public void onMyLocationChange(Location location) {
                        fListener.onMyLocationChange(location);
                    }
                });
    }

    public void stopAnimation() {
        mOriginal.stopAnimation();
    }

    public void setMaxZoomPreference(int i) {
        mOriginal.setMaxZoomPreference(i);
    }

    public void setBuildingsEnabled(boolean b) {

    }

    public final void setOnCameraMoveListener(final OnCameraMoveListener var1) {
        mOriginal.setOnCameraMoveListener(new GoogleMap.OnCameraMoveListener() {
            @Override
            public void onCameraMove() {
                var1.onCameraMove();
            }
        });
    }

    public void setOnCameraIdleListener(final OnCameraIdleListener listener) {

        mOriginal.setOnCameraIdleListener(new GoogleMap.OnCameraIdleListener() {
            @Override
            public void onCameraIdle() {
                listener.onCameraIdle();
            }
        });
    }

    public interface CancelableCallback {
        void onFinish();

        void onCancel();
    }

    public interface InfoWindowAdapter {
        View getInfoWindow(MaptexMarker paramMaptexMarker);

        View getInfoContents(MaptexMarker paramMaptexMarker);
    }

    public interface OnCameraChangeListener {
        void onCameraChange(MaptexCameraPosition position);
    }

    public interface OnCameraMoveListener {
        void onCameraMove();
    }

    public interface OnInfoWindowClickListener {
        void onInfoWindowClick(MaptexMarker paramMaptexMarker);
    }

    public interface OnMapClickListener {
        void onMapClick(MaptexLatLng paramLatLng);
    }

    public interface OnMapLongClickListener {
        void onMapLongClick(MaptexLatLng paramLatLng);
    }


    public interface OnMarkerClickListener {
        boolean onMarkerClick(MaptexMarker paramMaptexMarker);
    }

    public interface OnMarkerDragListener {
        void onMarkerDragStart(MaptexMarker paramMaptexMarker);

        void onMarkerDrag(MaptexMarker paramMaptexMarker);

        void onMarkerDragEnd(MaptexMarker paramMaptexMarker);
    }

    public interface OnMyLocationChangeListener {
        void onMyLocationChange(Location paramLocation);
    }

    public interface OnPolylineClickListener {
        void onPolylineClick(MaptexPolyline var1);
    }

    public interface OnCameraIdleListener {
        void onCameraIdle();
    }

    public interface OnCameraMoveStartedListener {
        int REASON_GESTURE = 1;
        int REASON_API_ANIMATION = 2;
        int REASON_DEVELOPER_ANIMATION = 3;

        void onCameraMoveStarted(int var1);
    }

}
