package ir.map.sdk_map.wrapper;

import android.content.Context;

import com.nostra13.universalimageloader.core.download.BaseImageDownloader;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;

import ir.map.sdk_map.MapSDK;

public class MapirImageDownloader extends BaseImageDownloader {

    public MapirImageDownloader(Context context) {
        super(context);
    }

    public MapirImageDownloader(Context context, int connectTimeout, int readTimeout) {
        super(context, connectTimeout, readTimeout);
    }

    @Override
    protected HttpURLConnection createConnection(String url, Object extra) throws IOException {
        HttpURLConnection conn = super.createConnection(url, extra);
        Map<String, String> headers = (Map<String, String>) extra;
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        conn.setRequestProperty("x-api-key", MapSDK.getToken());
        return conn;
    }
}