package ir.map.sdk_map;

import android.content.Context;
import android.support.annotation.NonNull;

public class MapSDK {

    private static Context libContext;
    private static String libToken;

    public static void init(@NonNull Context context, @NonNull String token) {
        libContext = context;
        libToken = token;
    }

    public static Context getContext() {
        if (libContext != null)
            return libContext;
        throw new NullPointerException("context is null. please init our libraries in your application class.");
    }

    public static String getToken() {
        if (libToken != null)
            return libToken;
        throw new NullPointerException("Token is null. Please provide valid token");
    }
}
