/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.wrapper;

import android.graphics.Bitmap;
import android.location.Location;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.LocationSource;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.TileProvider;
import com.google.android.gms.maps.model.UrlTileProvider;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.MapSDK;
import ir.map.sdk_map.wrapper.BaseMaptexUrlTileProvider;
import ir.map.sdk_map.wrapper.MaptexCameraPosition;
import ir.map.sdk_map.wrapper.MaptexCameraUpdate;
import ir.map.sdk_map.wrapper.MaptexCircle;
import ir.map.sdk_map.wrapper.MaptexCircleOptions;
import ir.map.sdk_map.wrapper.MaptexGroundOverlay;
import ir.map.sdk_map.wrapper.MaptexGroundOverlayOptions;
import ir.map.sdk_map.wrapper.MaptexLocationSource;
import ir.map.sdk_map.wrapper.MaptexMarker;
import ir.map.sdk_map.wrapper.MaptexMarkerOptions;
import ir.map.sdk_map.wrapper.MaptexPolygon;
import ir.map.sdk_map.wrapper.MaptexPolygonOptions;
import ir.map.sdk_map.wrapper.MaptexPolyline;
import ir.map.sdk_map.wrapper.MaptexPolylineOptions;
import ir.map.sdk_map.wrapper.MaptexProjection;
import ir.map.sdk_map.wrapper.MaptexTileOverlayOptions;
import ir.map.sdk_map.wrapper.MaptexUiSettings;
import ir.map.sdk_map.wrapper.k;
import ir.map.sdk_map.wrapper.l;
import ir.map.sdk_map.wrapper.m;
import ir.map.sdk_map.wrapper.n;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;

public final class MaptexMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    final GoogleMap mOriginal;

    MaptexMap(GoogleMap googleMap) {
        this.mOriginal = googleMap;
        this.mOriginal.setMapType(0);
        BaseMaptexUrlTileProvider baseMaptexUrlTileProvider = this.getCachingTile();
        this.mOriginal.addTileOverlay(new MaptexTileOverlayOptions().tileProvider((BaseMaptexUrlTileProvider)baseMaptexUrlTileProvider).mOriginal);
        this.mOriginal.getUiSettings().setMapToolbarEnabled(false);
        this.mOriginal.getUiSettings().setMyLocationButtonEnabled(false);
        this.mOriginal.getUiSettings().setCompassEnabled(false);
        this.mOriginal.getUiSettings().setZoomControlsEnabled(false);
    }

    private BaseMaptexUrlTileProvider getCachingTile() {
        DisplayImageOptions.Builder builder;
        final ImageLoader imageLoader = ImageLoader.getInstance();
        if (!ImageLoader.getInstance().isInited()) {
            builder = new ImageLoaderConfiguration.Builder(MapSDK.getContext()).build();
            ImageLoader.getInstance().init((ImageLoaderConfiguration)builder);
        }
        builder = new DisplayImageOptions.Builder();
        builder.cacheInMemory(true).cacheOnDisk(true);
        final DisplayImageOptions displayImageOptions = builder.build();
        BaseMaptexUrlTileProvider baseMaptexUrlTileProvider = new BaseMaptexUrlTileProvider(256, 256){

            @Override
            public synchronized URL getTileUrl(int n2, int n3, int n4) {
                return new n().a(n2, n3, n4);
            }

            @Override
            public k getTile(int n2, int n3, int n4) {
                byte[] byArray = this.a(n2, n3, n4);
                if (byArray != null) {
                    return new k(256, 256, byArray);
                }
                return m.d;
            }

            private byte[] a(int n2, int n3, int n4) {
                Bitmap bitmap = imageLoader.loadImageSync(this.getTileUrl(n2, n3, n4).toString(), displayImageOptions);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
                return byteArrayOutputStream.toByteArray();
            }
        };
        return baseMaptexUrlTileProvider;
    }

    public final MaptexCircle addCircle(MaptexCircleOptions maptexCircleOptions) {
        Circle circle = this.mOriginal.addCircle(maptexCircleOptions.mOriginal);
        circle.setZIndex(4.0f);
        return circle == null ? null : MaptexCircle.obtain(circle);
    }

    public final MaptexGroundOverlay addGroundOverlay(MaptexGroundOverlayOptions maptexGroundOverlayOptions) {
        GroundOverlay groundOverlay = this.mOriginal.addGroundOverlay(maptexGroundOverlayOptions.mOriginal);
        groundOverlay.setZIndex(4.0f);
        return groundOverlay == null ? null : MaptexGroundOverlay.obtain(groundOverlay);
    }

    public MaptexMarker addMarker(MaptexMarkerOptions maptexMarkerOptions) {
        Marker marker = this.mOriginal.addMarker(maptexMarkerOptions.mOriginal);
        return marker == null ? null : MaptexMarker.obtain(marker);
    }

    public final MaptexPolygon addPolygon(MaptexPolygonOptions maptexPolygonOptions) {
        Polygon polygon = this.mOriginal.addPolygon(maptexPolygonOptions.mOriginal);
        polygon.setZIndex(4.0f);
        return polygon == null ? null : MaptexPolygon.obtain(polygon);
    }

    public final MaptexPolyline addPolyline(MaptexPolylineOptions maptexPolylineOptions) {
        Polyline polyline = this.mOriginal.addPolyline(maptexPolylineOptions.mOriginal);
        polyline.setZIndex(4.0f);
        return polyline == null ? null : MaptexPolyline.obtain(polyline);
    }

    public final l addTileOverlay(MaptexTileOverlayOptions maptexTileOverlayOptions) {
        TileOverlay tileOverlay = this.mOriginal.addTileOverlay(maptexTileOverlayOptions.mOriginal);
        return tileOverlay == null ? null : l.a(tileOverlay);
    }

    public void animateCamera(MaptexCameraUpdate maptexCameraUpdate) {
        this.mOriginal.animateCamera(maptexCameraUpdate.mOriginal);
    }

    public void animateCamera(MaptexCameraUpdate maptexCameraUpdate, CancelableCallback cancelableCallback) {
        final CancelableCallback cancelableCallback2 = cancelableCallback;
        this.mOriginal.animateCamera(maptexCameraUpdate.mOriginal, cancelableCallback == null ? null : new GoogleMap.CancelableCallback(){

            public void onFinish() {
                cancelableCallback2.onFinish();
            }

            public void onCancel() {
                cancelableCallback2.onCancel();
            }
        });
    }

    public void animateCamera(MaptexCameraUpdate maptexCameraUpdate, int n2, CancelableCallback cancelableCallback) {
        final CancelableCallback cancelableCallback2 = cancelableCallback;
        this.mOriginal.animateCamera(maptexCameraUpdate.mOriginal, n2, cancelableCallback == null ? null : new GoogleMap.CancelableCallback(){

            public void onFinish() {
                cancelableCallback2.onFinish();
            }

            public void onCancel() {
                cancelableCallback2.onCancel();
            }
        });
    }

    public void clear() {
        this.mOriginal.clear();
        UrlTileProvider urlTileProvider = this.getCachingTile().mOriginal;
        this.mOriginal.addTileOverlay(new TileOverlayOptions().tileProvider((TileProvider)urlTileProvider));
    }

    public MaptexCameraPosition getCameraPosition() {
        CameraPosition cameraPosition = this.mOriginal.getCameraPosition();
        return cameraPosition == null ? null : MaptexCameraPosition.obtain(cameraPosition);
    }

    public int getMapType() {
        return this.mOriginal.getMapType();
    }

    public void setMapType(int n2) {
        this.mOriginal.setMapType(n2);
    }

    public Location getMyLocation() {
        return this.mOriginal.getMyLocation();
    }

    public MaptexProjection getProjection() {
        Projection projection = this.mOriginal.getProjection();
        return projection == null ? null : new MaptexProjection(projection);
    }

    public MaptexUiSettings getUiSettings() {
        UiSettings uiSettings = this.mOriginal.getUiSettings();
        return uiSettings == null ? null : new MaptexUiSettings(uiSettings);
    }

    public boolean isMyLocationEnabled() {
        return this.mOriginal.isMyLocationEnabled();
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void setMyLocationEnabled(boolean bl) {
        this.mOriginal.setMyLocationEnabled(bl);
    }

    public void moveCamera(MaptexCameraUpdate maptexCameraUpdate) {
        this.mOriginal.moveCamera(maptexCameraUpdate.mOriginal);
    }

    public boolean setIndoorEnabled(boolean bl) {
        return this.mOriginal.setIndoorEnabled(bl);
    }

    public void setLocationSource(MaptexLocationSource maptexLocationSource) {
        final MaptexLocationSource maptexLocationSource2 = maptexLocationSource;
        this.mOriginal.setLocationSource(maptexLocationSource2 == null ? null : new LocationSource(){

            public void activate(final LocationSource.OnLocationChangedListener onLocationChangedListener) {
                maptexLocationSource2.activate(new MaptexLocationSource.OnLocationChangedListener(){

                    @Override
                    public void onLocationChanged(Location location) {
                        onLocationChangedListener.onLocationChanged(location);
                    }
                });
            }

            public void deactivate() {
                maptexLocationSource2.deactivate();
            }
        });
    }

    public void setOnCameraChangeListener(OnCameraChangeListener onCameraChangeListener) {
        final OnCameraChangeListener onCameraChangeListener2 = onCameraChangeListener;
        this.mOriginal.setOnCameraChangeListener(onCameraChangeListener2 == null ? null : new GoogleMap.OnCameraChangeListener(){

            public void onCameraChange(CameraPosition cameraPosition) {
                onCameraChangeListener2.onCameraChange(MaptexCameraPosition.obtain(cameraPosition));
            }
        });
    }

    public final void setOnCameraMoveStartedListener(c c2) {
        final c c3 = c2;
        this.mOriginal.setOnCameraMoveStartedListener(c3 == null ? null : new GoogleMap.OnCameraMoveStartedListener(){

            public void onCameraMoveStarted(int n2) {
                c3.a(n2);
            }
        });
    }

    public void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        final OnMapClickListener onMapClickListener2 = onMapClickListener;
        this.mOriginal.setOnMapClickListener(onMapClickListener2 == null ? null : new GoogleMap.OnMapClickListener(){

            public void onMapClick(LatLng latLng) {
                onMapClickListener2.onMapClick(new MaptexLatLng(latLng.latitude, latLng.longitude));
            }
        });
    }

    public void setOnPolylineClickListener(final e e2) {
        e e3 = e2;
        this.mOriginal.setOnPolylineClickListener(e3 == null ? null : new GoogleMap.OnPolylineClickListener(){

            public void onPolylineClick(Polyline polyline) {
                e2.a(MaptexPolyline.obtain(polyline));
            }
        });
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        final OnMapLongClickListener onMapLongClickListener2 = onMapLongClickListener;
        this.mOriginal.setOnMapLongClickListener(onMapLongClickListener2 == null ? null : new GoogleMap.OnMapLongClickListener(){

            public void onMapLongClick(LatLng latLng) {
                onMapLongClickListener2.onMapLongClick(new MaptexLatLng(latLng.latitude, latLng.longitude));
            }
        });
    }

    public void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        final OnMarkerClickListener onMarkerClickListener2 = onMarkerClickListener;
        this.mOriginal.setOnMarkerClickListener(onMarkerClickListener2 == null ? null : new GoogleMap.OnMarkerClickListener(){

            public boolean onMarkerClick(Marker marker) {
                return onMarkerClickListener2.onMarkerClick(MaptexMarker.obtain(marker));
            }
        });
    }

    public final void setInfoWindowAdapter(InfoWindowAdapter infoWindowAdapter) {
        final InfoWindowAdapter infoWindowAdapter2 = infoWindowAdapter;
        this.mOriginal.setInfoWindowAdapter(infoWindowAdapter2 == null ? null : new GoogleMap.InfoWindowAdapter(){

            public View getInfoWindow(Marker marker) {
                return infoWindowAdapter2.getInfoWindow(MaptexMarker.obtain(marker));
            }

            public View getInfoContents(Marker marker) {
                return infoWindowAdapter2.getInfoContents(MaptexMarker.obtain(marker));
            }
        });
    }

    public final void setOnInfoWindowClickListener(OnInfoWindowClickListener onInfoWindowClickListener) {
        final OnInfoWindowClickListener onInfoWindowClickListener2 = onInfoWindowClickListener;
        this.mOriginal.setOnInfoWindowClickListener(onInfoWindowClickListener2 == null ? null : new GoogleMap.OnInfoWindowClickListener(){

            public void onInfoWindowClick(Marker marker) {
                onInfoWindowClickListener2.onInfoWindowClick(MaptexMarker.obtain(marker));
            }
        });
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        final OnMarkerDragListener onMarkerDragListener2 = onMarkerDragListener;
        this.mOriginal.setOnMarkerDragListener(onMarkerDragListener2 == null ? null : new GoogleMap.OnMarkerDragListener(){

            public void onMarkerDrag(Marker marker) {
                onMarkerDragListener2.onMarkerDrag(MaptexMarker.obtain(marker));
            }

            public void onMarkerDragEnd(Marker marker) {
                onMarkerDragListener2.onMarkerDragEnd(MaptexMarker.obtain(marker));
            }

            public void onMarkerDragStart(Marker marker) {
                onMarkerDragListener2.onMarkerDragStart(MaptexMarker.obtain(marker));
            }
        });
    }

    public final void setOnMyLocationChangeListener(d d2) {
        final d d3 = d2;
        this.mOriginal.setOnMyLocationChangeListener(d3 == null ? null : new GoogleMap.OnMyLocationChangeListener(){

            public void onMyLocationChange(Location location) {
                d3.a(location);
            }
        });
    }

    public void stopAnimation() {
        this.mOriginal.stopAnimation();
    }

    public void setMaxZoomPreference(int n2) {
        this.mOriginal.setMaxZoomPreference((float)n2);
    }

    public void setBuildingsEnabled(boolean bl) {
    }

    public final void setOnCameraMoveListener(final b b2) {
        this.mOriginal.setOnCameraMoveListener(new GoogleMap.OnCameraMoveListener(){

            public void onCameraMove() {
                b2.a();
            }
        });
    }

    public void setOnCameraIdleListener(final a a2) {
        this.mOriginal.setOnCameraIdleListener(new GoogleMap.OnCameraIdleListener(){

            public void onCameraIdle() {
                a2.onCameraIdle();
            }
        });
    }

    public static interface c {
        public void a(int var1);
    }

    public static interface a {
        public void onCameraIdle();
    }

    public static interface e {
        public void a(MaptexPolyline var1);
    }

    public static interface d {
        public void a(Location var1);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(MaptexMarker var1);

        public void onMarkerDrag(MaptexMarker var1);

        public void onMarkerDragEnd(MaptexMarker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(MaptexMarker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(MaptexLatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(MaptexLatLng var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(MaptexMarker var1);
    }

    public static interface b {
        public void a();
    }

    public static interface OnCameraChangeListener {
        public void onCameraChange(MaptexCameraPosition var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(MaptexMarker var1);

        public View getInfoContents(MaptexMarker var1);
    }

    public static interface CancelableCallback {
        public void onFinish();

        public void onCancel();
    }
}

