/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.wrapper;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.MapSDK;

public final class MaptexCameraPosition
implements Parcelable {
    public static final Parcelable.Creator<MaptexCameraPosition> CREATOR = new Parcelable.Creator<MaptexCameraPosition>(){

        public MaptexCameraPosition a(Parcel parcel) {
            return new MaptexCameraPosition((CameraPosition)parcel.readParcelable(null));
        }

        public MaptexCameraPosition[] a(int n2) {
            return new MaptexCameraPosition[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };
    public final CameraPosition mOriginal;
    public final float bearing;
    public final MaptexLatLng target;
    public final float tilt;
    public final float zoom;

    private MaptexCameraPosition(CameraPosition cameraPosition) {
        this.mOriginal = cameraPosition;
        this.bearing = cameraPosition.bearing;
        this.target = new MaptexLatLng(cameraPosition.target.latitude, cameraPosition.target.longitude);
        this.tilt = cameraPosition.tilt;
        this.zoom = cameraPosition.zoom;
    }

    public MaptexCameraPosition(MaptexLatLng maptexLatLng, int n2, float f2, float f3) {
        this.mOriginal = new CameraPosition(new LatLng(maptexLatLng.latitude, maptexLatLng.longitude), (float)n2, f2, f3);
        this.bearing = f3;
        this.target = new MaptexLatLng(maptexLatLng.latitude, maptexLatLng.longitude);
        this.tilt = f2;
        this.zoom = n2;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MaptexCameraPosition maptexCameraPosition) {
        return new Builder(maptexCameraPosition);
    }

    public static MaptexCameraPosition createFromAttributes(AttributeSet attributeSet) {
        return new MaptexCameraPosition(CameraPosition.createFromAttributes((Context)MapSDK.getContext(), (AttributeSet)attributeSet));
    }

    public static MaptexCameraPosition fromLatLngZoom(MaptexLatLng maptexLatLng, float f2) {
        return new MaptexCameraPosition(CameraPosition.fromLatLngZoom((LatLng)(maptexLatLng == null ? null : new LatLng(maptexLatLng.latitude, maptexLatLng.longitude)), (float)f2));
    }

    public static MaptexCameraPosition obtain(CameraPosition cameraPosition) {
        return new MaptexCameraPosition(cameraPosition);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MaptexCameraPosition)) {
            return false;
        }
        return this.mOriginal.equals((Object)((MaptexCameraPosition)object).mOriginal);
    }

    public int hashCode() {
        return this.mOriginal.hashCode();
    }

    public String toString() {
        return this.mOriginal.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeParcelable((Parcelable)this.mOriginal, n2);
    }

    public static final class Builder {
        private CameraPosition.Builder mOriginal;

        public Builder() {
            this(new CameraPosition.Builder());
        }

        public Builder(MaptexCameraPosition maptexCameraPosition) {
            this(new CameraPosition.Builder(maptexCameraPosition == null ? null : maptexCameraPosition.mOriginal));
        }

        private Builder(CameraPosition.Builder builder) {
            this.mOriginal = builder;
        }

        public Builder bearing(float f2) {
            this.mOriginal.bearing(f2);
            return this;
        }

        public MaptexCameraPosition build() {
            return new MaptexCameraPosition(this.mOriginal.build());
        }

        public Builder target(MaptexLatLng maptexLatLng) {
            this.mOriginal.target(maptexLatLng == null ? null : new LatLng(maptexLatLng.latitude, maptexLatLng.longitude));
            return this;
        }

        public Builder tilt(float f2) {
            this.mOriginal.tilt(f2);
            return this;
        }

        public Builder zoom(float f2) {
            this.mOriginal.zoom(f2);
            return this;
        }
    }
}

