package ir.map.sdk_map.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import ir.map.sdk_common.MaptexLatLng;

/**
 * @author haniyeh
 */

public class MaptexStaticCluster<T extends MaptexClusterItem> implements MaptexCluster<T> {
    private final MaptexLatLng mCenter;
    private final List<T> mItems = new ArrayList();

    public MaptexStaticCluster(MaptexLatLng center) {
        this.mCenter = center;
    }

    public boolean add(T t) {
        return this.mItems.add(t);
    }

    public MaptexLatLng getPosition() {
        return this.mCenter;
    }

    public boolean remove(T t) {
        return this.mItems.remove(t);
    }

    public Collection<T> getItems() {
        return this.mItems;
    }

    public int getSize() {
        return this.mItems.size();
    }

    public String toString() {
        return "StaticCluster{mCenter=" + this.mCenter + ", mItems.size=" + this.mItems.size() + '}';
    }

    public int hashCode() {
        return this.mCenter.hashCode() + this.mItems.hashCode();
    }

    public boolean equals(Object other) {
        return !(other instanceof MaptexStaticCluster) ? false : ((MaptexStaticCluster) other).mCenter
                .equals(this.mCenter) && ((MaptexStaticCluster) other).mItems.equals(this.mItems);
    }
}
