package ir.map.sdk_map.wrapper;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.android.gms.maps.model.LatLng;

import java.util.List;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.internal.ListTranslators;
import ir.map.sdk_map.internal.ListWrappers;


public final class MaptexPolygonOptions implements Parcelable {

    public static final Creator<MaptexPolygonOptions> CREATOR = new Creator<MaptexPolygonOptions>() {
        public MaptexPolygonOptions createFromParcel(Parcel in) {
            return new MaptexPolygonOptions((com.google.android.gms.maps.model.PolygonOptions) in.readParcelable(null));
        }

        public MaptexPolygonOptions[] newArray(int size) {
            return new MaptexPolygonOptions[size];
        }
    };

    /**
     * DO NOT USE. The original MaptexPolygonOptions.
     *

     */
    public final com.google.android.gms.maps.model.PolygonOptions mOriginal;

    private MaptexPolygonOptions mDefaultOptions;

    public MaptexPolygonOptions() {
        this(new com.google.android.gms.maps.model.PolygonOptions());
    }

    MaptexPolygonOptions(com.google.android.gms.maps.model.PolygonOptions original) {
        mOriginal = original;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(mOriginal, flags);
    }

    public MaptexPolygonOptions add(MaptexLatLng point) {
        mOriginal.add(new LatLng(point.latitude, point.longitude));
        return this;
    }

    public MaptexPolygonOptions add(MaptexLatLng... points) {
        mOriginal.add(points == null ? null : ListTranslators.latLngs(points));
        return this;
    }

    public MaptexPolygonOptions addAll(Iterable<MaptexLatLng> points) {
        mOriginal.addAll(points == null ? null : ListTranslators.latLngList(points));
        return this;
    }

    public MaptexPolygonOptions addHole(Iterable<MaptexLatLng> points) {
        mOriginal.addHole(points == null ? null : ListTranslators.latLngList(points));
        return this;
    }

    public MaptexPolygonOptions fillColor(int color) {
        mOriginal.fillColor(color);
        return this;
    }

    public int getFillColor() {
        return mOriginal.getFillColor();
    }

    public List<List<MaptexLatLng>> getHoles() {
        final List<List<com.google.android.gms.maps.model.LatLng>> originals = mOriginal.getHoles();
        return originals == null ? null : ListWrappers.forLatLngList(originals);
    }

    public List<MaptexLatLng> getPoints() {
        final List<com.google.android.gms.maps.model.LatLng> originals = mOriginal.getPoints();
        return originals == null ? null : ListWrappers.forLatLng(originals);
    }

    public int getStrokeColor() {
        return mOriginal.getStrokeColor();
    }

    public float getStrokeWidth() {
        return mOriginal.getStrokeWidth();
    }

    public float getZIndex() {
        return mOriginal.getZIndex();
    }

    public MaptexPolygonOptions geodesic(boolean geodesic) {
        mOriginal.geodesic(geodesic);
        return this;
    }

    public boolean isGeodesic() {
        return mOriginal.isGeodesic();
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    /**
     * Reset the MaptexPolygonOptions by setting all of its properties to their default values.
     */
    @Maptex
    public void reset() {
        if (mDefaultOptions == null) {
            mDefaultOptions = new MaptexPolygonOptions();
        }

        fillColor(mDefaultOptions.getFillColor());
        geodesic(mDefaultOptions.isGeodesic());
        strokeColor(mDefaultOptions.getStrokeColor());
        strokeWidth(mDefaultOptions.getStrokeWidth());
        visible(mDefaultOptions.isVisible());
        zIndex(mDefaultOptions.getZIndex());
        // HACK Cyril: The following lines imply get[Points|Holes]() return the internal
        // list of points instead of a copy ... actually there's no guarantee of it.
        getPoints().clear();
        getHoles().clear();
    }

    public MaptexPolygonOptions strokeColor(int color) {
        mOriginal.strokeColor(color);
        return this;
    }

    public MaptexPolygonOptions strokeWidth(float width) {
        mOriginal.strokeWidth(width);
        return this;
    }

    public MaptexPolygonOptions visible(boolean visible) {
        mOriginal.visible(visible);
        return this;
    }

    public MaptexPolygonOptions zIndex(float zIndex) {
        mOriginal.zIndex(zIndex);
        return this;
    }

    public MaptexPolygonOptions strokeJointType(int i) {
        mOriginal.strokeJointType(i);
        return this;
    }

    public MaptexPolygonOptions clickable(boolean b) {
        mOriginal.clickable(b);
        return this;
    }
}
