package ir.map.sdk_map.wrapper;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;


public final class MaptexMarkerOptions implements Parcelable {

    public static final Creator<MaptexMarkerOptions> CREATOR = new Creator<MaptexMarkerOptions>() {
        public MaptexMarkerOptions createFromParcel(Parcel in) {
            return new MaptexMarkerOptions((com.google.android.gms.maps.model.MarkerOptions) in.readParcelable(null));
        }

        public MaptexMarkerOptions[] newArray(int size) {
            return new MaptexMarkerOptions[size];
        }
    };

    /**
     * DO NOT USE. The original MaptexMarkerOptions.
     *

     */
    public final com.google.android.gms.maps.model.MarkerOptions mOriginal;

    private MaptexMarkerOptions mDefaultOptions;

    public MaptexMarkerOptions() {
        this(new com.google.android.gms.maps.model.MarkerOptions());
    }

    MaptexMarkerOptions(com.google.android.gms.maps.model.MarkerOptions original) {
        mOriginal = original;
    }

    @Override
    public int describeContents() {
        return mOriginal.describeContents();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(mOriginal, flags);
    }

    public MaptexMarkerOptions anchor(float u, float v) {
        mOriginal.anchor(u, v);
        return this;
    }

    public MaptexMarkerOptions draggable(boolean draggable) {
        mOriginal.draggable(draggable);
        return this;
    }

    public float getAnchorU() {
        return mOriginal.getAnchorU();
    }

    public float getAnchorV() {
        return mOriginal.getAnchorV();
    }

    public MaptexBitmapDescriptor getIcon() {
        final com.google.android.gms.maps.model.BitmapDescriptor original = mOriginal.getIcon();
        return original == null ? null : new MaptexBitmapDescriptor(original);
    }

    public MaptexLatLng getPosition() {
        final com.google.android.gms.maps.model.LatLng original = mOriginal.getPosition();
        return original == null ? null : new MaptexLatLng(original.latitude, original.longitude);
    }

    public String getSnippet() {
        return mOriginal.getSnippet();
    }

    public String getTitle() {
        return mOriginal.getTitle();
    }

    public MaptexMarkerOptions icon(MaptexBitmapDescriptor icon) {
        mOriginal.icon(icon == null ? null : icon.mOriginal);
        return this;
    }

    public boolean isDraggable() {
        return mOriginal.isDraggable();
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    public MaptexMarkerOptions position(MaptexLatLng position) {
        mOriginal.position(position == null ? null : new LatLng(position.latitude, position.longitude));
        return this;
    }

    /**
     * Reset the MaptexMarkerOptions by setting all of its properties to their default values.
     */
    @Maptex
    public void reset() {
        if (mDefaultOptions == null) {
            mDefaultOptions = new MaptexMarkerOptions();
        }
        anchor(mDefaultOptions.getAnchorU(), mDefaultOptions.getAnchorV());
        draggable(mDefaultOptions.isDraggable());
        icon(mDefaultOptions.getIcon());
        position(mDefaultOptions.getPosition());
        snippet(mDefaultOptions.getSnippet());
        title(mDefaultOptions.getTitle());
        visible(mDefaultOptions.isVisible());
    }

    public MaptexMarkerOptions snippet(String snippet) {
        mOriginal.snippet(snippet);
        return this;
    }

    public MaptexMarkerOptions title(String title) {
        mOriginal.title(title);
        return this;
    }

    public MaptexMarkerOptions visible(boolean visible) {
        mOriginal.visible(visible);
        return this;
    }

    public MaptexMarkerOptions zIndex(int markerIndex) {
        mOriginal.zIndex(markerIndex);
        return this;
    }

    public MaptexMarkerOptions alpha(float v) {
        mOriginal.alpha(v);
        return this;
    }
}
