package ir.map.sdk_map.wrapper;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;


public final class MaptexMapOptions implements Parcelable {

    public static final Creator<MaptexMapOptions> CREATOR = new Creator<MaptexMapOptions>() {
        public MaptexMapOptions createFromParcel(Parcel in) {
            return new MaptexMapOptions((com.google.android.gms.maps.GoogleMapOptions) in.readParcelable(null));
        }

        public MaptexMapOptions[] newArray(int size) {
            return new MaptexMapOptions[size];
        }
    };

    final com.google.android.gms.maps.GoogleMapOptions mOriginal;

    private MaptexMapOptions mDefaultOptions;

    public MaptexMapOptions() {
        this(new com.google.android.gms.maps.GoogleMapOptions());
    }

    MaptexMapOptions(com.google.android.gms.maps.GoogleMapOptions original) {
        mOriginal = original;
    }

    public static MaptexMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        return new MaptexMapOptions(com.google.android.gms.maps.GoogleMapOptions.createFromAttributes(context, attrs));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(mOriginal, flags);
    }

    public MaptexMapOptions camera(MaptexCameraPosition camera) {
        mOriginal.camera(camera.mOriginal);
        return this;
    }

    public MaptexMapOptions compassEnabled(boolean enabled) {
        mOriginal.compassEnabled(enabled);
        return this;
    }

    public MaptexCameraPosition getCamera() {
        final com.google.android.gms.maps.model.CameraPosition original = mOriginal.getCamera();
        return original == null ? null : MaptexCameraPosition.obtain(original);
    }

    public Boolean getCompassEnabled() {
        return mOriginal.getCompassEnabled();
    }

    public int getMapType() {
        return mOriginal.getMapType();
    }

    public Boolean getScrollGesturesEnabled() {
        return mOriginal.getScrollGesturesEnabled();
    }

    public Boolean getRotateGesturesEnabled() {
        return mOriginal.getRotateGesturesEnabled();
    }

    public Boolean getTiltGesturesEnabled() {
        return mOriginal.getTiltGesturesEnabled();
    }

    public Boolean getUseViewLifecycleInFragment() {
        return mOriginal.getUseViewLifecycleInFragment();
    }

    public Boolean getZoomControlsEnabled() {
        return mOriginal.getZoomControlsEnabled();
    }

    public Boolean getZoomGesturesEnabled() {
        return mOriginal.getZoomControlsEnabled();
    }

    public Boolean getZOrderOnTop() {
        return mOriginal.getZOrderOnTop();
    }

    public MaptexMapOptions mapType(int mapType) {
        mOriginal.mapType(mapType);
        return this;
    }

    /**
     * Reset the MaptexMapOptions by setting all of its properties to their default values.
     */
    @Maptex
    public void reset() {
        if (mDefaultOptions == null) {
            mDefaultOptions = new MaptexMapOptions();
        }
        camera(mDefaultOptions.getCamera());
        compassEnabled(mDefaultOptions.getCompassEnabled());
        mapType(mDefaultOptions.getMapType());
        scrollGesturesEnabled(mDefaultOptions.getScrollGesturesEnabled());
        rotateGesturesEnabled(mDefaultOptions.getRotateGesturesEnabled());
        tiltGesturesEnabled(mDefaultOptions.getTiltGesturesEnabled());
        useViewLifecycleInFragment(mDefaultOptions.getUseViewLifecycleInFragment());
        zoomControlsEnabled(mDefaultOptions.getZoomControlsEnabled());
        zoomGesturesEnabled(mDefaultOptions.getZoomGesturesEnabled());
        zOrderOnTop(mDefaultOptions.getZOrderOnTop());
    }

    public MaptexMapOptions rotateGesturesEnabled(boolean enabled) {
        mOriginal.rotateGesturesEnabled(enabled);
        return this;
    }

    public MaptexMapOptions scrollGesturesEnabled(boolean enabled) {
        mOriginal.scrollGesturesEnabled(enabled);
        return this;
    }

    public MaptexMapOptions tiltGesturesEnabled(boolean enabled) {
        mOriginal.tiltGesturesEnabled(enabled);
        return this;
    }

    public MaptexMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        mOriginal.useViewLifecycleInFragment(useViewLifecycleInFragment);
        return this;
    }

    public MaptexMapOptions zoomControlsEnabled(boolean enabled) {
        mOriginal.zoomControlsEnabled(enabled);
        return this;
    }

    public MaptexMapOptions zoomGesturesEnabled(boolean enabled) {
        mOriginal.zoomGesturesEnabled(enabled);
        return this;
    }

    public MaptexMapOptions zOrderOnTop(boolean zOrderOnTop) {
        mOriginal.zOrderOnTop(zOrderOnTop);
        return this;
    }

}
