package ir.map.sdk_map.wrapper;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;


public final class MaptexLatLngBounds implements Parcelable {

    public static final Creator<MaptexLatLngBounds> CREATOR = new Creator<MaptexLatLngBounds>() {
        public MaptexLatLngBounds createFromParcel(Parcel in) {
            return new MaptexLatLngBounds((com.google.android.gms.maps.model.LatLngBounds) in.readParcelable(null));
        }

        public MaptexLatLngBounds[] newArray(int size) {
            return new MaptexLatLngBounds[size];
        }
    };

    @Maptex
    public static final MaptexLatLngBounds EARTH_BOUNDS = new MaptexLatLngBounds(new MaptexLatLng(MaptexLatLng.MIN_LATITUDE, MaptexLatLng.MIN_LONGITUDE), new MaptexLatLng(
            MaptexLatLng.MAX_LATITUDE, MaptexLatLng.MAX_LONGITUDE));

    /**
     * <strong>DO NOT USE.</strong>

     * The original (immutable) MaptexLatLngBounds.
     *

     */
    public final com.google.android.gms.maps.model.LatLngBounds mOriginal;

    public final MaptexLatLng southwest;
    public final MaptexLatLng northeast;

    public MaptexLatLngBounds(MaptexLatLng southwest, MaptexLatLng northeast) {
        this(new com.google.android.gms.maps.model.LatLngBounds(southwest == null ? null : new LatLng(southwest.latitude, southwest.longitude),
                northeast == null ? null : new LatLng(northeast.latitude, northeast.longitude)));
    }

    private MaptexLatLngBounds(com.google.android.gms.maps.model.LatLngBounds original) {
        mOriginal = original;

        southwest = original.southwest == null ? null : new MaptexLatLng(original.southwest.latitude, original.southwest.longitude);
        northeast = original.northeast == null ? null : new MaptexLatLng(original.northeast.latitude, original.northeast.longitude);
    }

    static MaptexLatLngBounds obtain(com.google.android.gms.maps.model.LatLngBounds original) {
        return new MaptexLatLngBounds(original);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaptexLatLngBounds)) {
            return false;
        }
        return mOriginal.equals(((MaptexLatLngBounds) other).mOriginal);
    }

    @Override
    public int hashCode() {
        return mOriginal.hashCode();
    }

    @Override
    public String toString() {
        return mOriginal.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(mOriginal, flags);
    }

    public boolean contains(MaptexLatLng point) {
        return mOriginal.contains(point == null ? null : new LatLng(point.latitude, point.longitude));
    }

    public MaptexLatLngBounds including(MaptexLatLng point) {
        return new MaptexLatLngBounds(mOriginal.including(point == null ? null : new LatLng(point.latitude, point.longitude)));
    }

    /**
     * Check whether the given bounds intersects with ourselves.
     *
     * @param bounds The bounds to check
     * @return true if the given bounds intersect ourselves, false otherwise
     */
    @Maptex
    public boolean intersects(MaptexLatLngBounds bounds) {
        final boolean latIntersects =
                (bounds.northeast.latitude >= southwest.latitude) && (bounds.southwest.latitude <= northeast.latitude);
        final boolean lngIntersects =
                (bounds.northeast.longitude >= southwest.longitude) && (bounds.southwest.longitude <= northeast.longitude);

        return latIntersects && lngIntersects;
    }

    public static final class Builder {
        private final com.google.android.gms.maps.model.LatLngBounds.Builder mOriginal;

        public Builder() {
            this(new com.google.android.gms.maps.model.LatLngBounds.Builder());
        }

        private Builder(com.google.android.gms.maps.model.LatLngBounds.Builder original) {
            mOriginal = original;
        }

        public MaptexLatLngBounds build() {
            return new MaptexLatLngBounds(mOriginal.build());
        }

        public Builder include(MaptexLatLng point) {
            mOriginal.include(new LatLng(point.latitude, point.longitude));
            return this;
        }
    }

}
