package ir.map.sdk_map.wrapper;

import android.graphics.Point;

import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;


public final class MaptexCameraUpdateFactory {

    private MaptexCameraUpdateFactory() {
        // No instances
    }

    public static MaptexCameraUpdate newCameraPosition(MaptexCameraPosition maptexCameraPosition) {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.newCameraPosition(maptexCameraPosition.mOriginal));
    }

    public static MaptexCameraUpdate newLatLng(MaptexLatLng latLng) {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.newLatLng(new LatLng(latLng.latitude, latLng.longitude)));
    }

    public static MaptexCameraUpdate newLatLngBounds(MaptexLatLngBounds laLngBounds, int padding) {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.newLatLngBounds(laLngBounds.mOriginal, padding));
    }

    public static MaptexCameraUpdate newLatLngBounds(MaptexLatLngBounds maptexLatLngBounds, int width, int height, int padding) {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.newLatLngBounds(maptexLatLngBounds.mOriginal, width, height,
                padding));
    }

    public static MaptexCameraUpdate newLatLngZoom(MaptexLatLng latLng, float zoom) {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.newLatLngZoom(new LatLng(latLng.latitude, latLng.longitude), zoom));
    }

    public static MaptexCameraUpdate scrollBy(float xPixel, float yPixel) {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.scrollBy(xPixel, yPixel));
    }

    public static MaptexCameraUpdate zoomBy(float amount) {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.zoomBy(amount));
    }

    public static MaptexCameraUpdate zoomBy(float amount, Point focus) {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.zoomBy(amount, focus));
    }

    public static MaptexCameraUpdate zoomIn() {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.zoomIn());
    }

    public static MaptexCameraUpdate zoomOut() {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.zoomOut());
    }

    public static MaptexCameraUpdate zoomTo(float zoom) {
        return new MaptexCameraUpdate(com.google.android.gms.maps.CameraUpdateFactory.zoomTo(zoom));
    }

}
