/*
 * Copyright (C) 2013 Cyril Mottier (http://cyrilmottier.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ir.map.sdk_map.internal;

import com.google.android.gms.maps.model.LatLng;

import java.util.ArrayList;
import java.util.List;

import ir.map.sdk_common.MaptexLatLng;

public final class ListTranslators {

    private ListTranslators() {
    }

    public static List<List<com.google.android.gms.maps.model.LatLng>> latLngListList(List<? extends List<MaptexLatLng>> holes) {
        final ArrayList<List<com.google.android.gms.maps.model.LatLng>> originals = newArrayList(holes.size());
        for (int i = 0; i < holes.size(); i++) {
            final List<MaptexLatLng> hole = holes.get(i);
            final ArrayList<com.google.android.gms.maps.model.LatLng> originalHole = newArrayList(hole.size());
            for (int j = 0; j < hole.size(); j++) {
                originalHole.add(new LatLng(hole.get(j).latitude, hole.get(i).longitude));
            }
            originals.add(originalHole);
        }
        return originals;
    }

    public static com.google.android.gms.maps.model.LatLng[] latLngs(MaptexLatLng[] points) {
        final com.google.android.gms.maps.model.LatLng[] originals = new com.google.android.gms.maps.model.LatLng[points.length];
        for (int i = 0; i < points.length; i++) {
            originals[i] = new LatLng(points[i].latitude, points[i].longitude);
        }
        return originals;
    }

    public static List<com.google.android.gms.maps.model.LatLng> latLngList(Iterable<MaptexLatLng> points) {
        final ArrayList<com.google.android.gms.maps.model.LatLng> originals = new ArrayList<com.google.android.gms.maps.model.LatLng>();
        for (MaptexLatLng latLng : points) {
            originals.add(new LatLng(latLng.latitude, latLng.longitude));
        }
        return originals;
    }

    private static <E> ArrayList<E> newArrayList(int capacity) {
        return new ArrayList<>(capacity);
    }

}
