/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.FrameLayout;

public class RotationLayout
extends FrameLayout {
    private int mRotation;

    public RotationLayout(Context context) {
        super(context);
    }

    public RotationLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public RotationLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    protected void onMeasure(int n, int n2) {
        if (this.mRotation == 1 || this.mRotation == 3) {
            super.onMeasure(n, n2);
            this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
        } else {
            super.onMeasure(n, n2);
        }
    }

    public void setViewRotation(int n) {
        this.mRotation = (n + 360) % 360 / 90;
    }

    public void dispatchDraw(Canvas canvas) {
        if (this.mRotation == 0) {
            super.dispatchDraw(canvas);
            return;
        }
        if (this.mRotation == 1) {
            canvas.translate((float)this.getWidth(), 0.0f);
            canvas.rotate(90.0f, (float)(this.getWidth() / 2), 0.0f);
            canvas.translate((float)(this.getHeight() / 2), (float)(this.getWidth() / 2));
        } else if (this.mRotation == 2) {
            canvas.rotate(180.0f, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        } else {
            canvas.translate(0.0f, (float)this.getHeight());
            canvas.rotate(270.0f, (float)(this.getWidth() / 2), 0.0f);
            canvas.translate((float)(this.getHeight() / 2), (float)(-this.getWidth() / 2));
        }
        super.dispatchDraw(canvas);
    }
}

