/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.MaptexSphericalUtil;
import ir.map.sdk_map.a;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class MaptexPolyUtil {
    private static final double DEFAULT_TOLERANCE = 0.1;

    private MaptexPolyUtil() {
    }

    private static double tanLatGC(double d2, double d3, double d4, double d5) {
        return (Math.tan(d2) * Math.sin(d4 - d5) + Math.tan(d3) * Math.sin(d5)) / Math.sin(d4);
    }

    private static double mercatorLatRhumb(double d2, double d3, double d4, double d5) {
        return (a.a(d2) * (d4 - d5) + a.a(d3) * d5) / d4;
    }

    private static boolean intersects(double d2, double d3, double d4, double d5, double d6, boolean bl) {
        if ((d6 < 0.0 || d6 < d4) && (d6 >= 0.0 || d6 >= d4)) {
            if (d5 <= -1.5707963267948966) {
                return false;
            }
            if (d2 > -1.5707963267948966 && d3 > -1.5707963267948966 && d2 < 1.5707963267948966 && d3 < 1.5707963267948966) {
                if (d4 <= -Math.PI) {
                    return false;
                }
                double d7 = (d2 * (d4 - d6) + d3 * d6) / d4;
                return d2 >= 0.0 && d3 >= 0.0 && d5 < d7 ? false : (d2 <= 0.0 && d3 <= 0.0 && d5 >= d7 ? true : (d5 >= 1.5707963267948966 ? true : (bl ? Math.tan(d5) >= MaptexPolyUtil.tanLatGC(d2, d3, d4, d6) : a.a(d5) >= MaptexPolyUtil.mercatorLatRhumb(d2, d3, d4, d6))));
            }
            return false;
        }
        return false;
    }

    public static boolean isLocationOnEdge(MaptexLatLng maptexLatLng, List<MaptexLatLng> list, boolean bl, double d2) {
        return MaptexPolyUtil.isLocationOnEdgeOrPath(maptexLatLng, list, true, bl, d2);
    }

    public static boolean isLocationOnEdge(MaptexLatLng maptexLatLng, List<MaptexLatLng> list, boolean bl) {
        return MaptexPolyUtil.isLocationOnEdge(maptexLatLng, list, bl, 0.1);
    }

    public static boolean isLocationOnPath(MaptexLatLng maptexLatLng, List<MaptexLatLng> list, boolean bl, double d2) {
        return MaptexPolyUtil.isLocationOnEdgeOrPath(maptexLatLng, list, false, bl, d2);
    }

    public static boolean isLocationOnPath(MaptexLatLng maptexLatLng, List<MaptexLatLng> list, boolean bl) {
        return MaptexPolyUtil.isLocationOnPath(maptexLatLng, list, bl, 0.1);
    }

    private static boolean isLocationOnEdgeOrPath(MaptexLatLng maptexLatLng, List<MaptexLatLng> list, boolean bl, boolean bl2, double d2) {
        int n = list.size();
        if (n == 0) {
            return false;
        }
        double d3 = d2 / 6371009.0;
        double d4 = a.c(d3);
        double d5 = Math.toRadians(maptexLatLng.latitude);
        double d6 = Math.toRadians(maptexLatLng.longitude);
        MaptexLatLng maptexLatLng2 = list.get(bl ? n - 1 : 0);
        double d7 = Math.toRadians(maptexLatLng2.latitude);
        double d8 = Math.toRadians(maptexLatLng2.longitude);
        if (bl2) {
            for (MaptexLatLng maptexLatLng3 : list) {
                double d9;
                double d10 = Math.toRadians(maptexLatLng3.latitude);
                if (MaptexPolyUtil.isOnSegmentGC(d7, d8, d10, d9 = Math.toRadians(maptexLatLng3.longitude), d5, d6, d4)) {
                    return true;
                }
                d7 = d10;
                d8 = d9;
            }
        } else {
            double d11 = d5 - d3;
            double d12 = d5 + d3;
            double d13 = a.a(d7);
            double d14 = a.a(d5);
            double[] dArray = new double[3];
            for (MaptexLatLng maptexLatLng4 : list) {
                d12 = Math.toRadians(maptexLatLng4.latitude);
                double d15 = a.a(d12);
                double d16 = Math.toRadians(maptexLatLng4.longitude);
                if (Math.max(d7, d12) >= d11 && Math.min(d7, d12) <= d12) {
                    double d17;
                    double d18 = a.b(d16 - d8, -Math.PI, Math.PI);
                    dArray[0] = d17 = a.b(d6 - d8, -Math.PI, Math.PI);
                    dArray[1] = d17 + Math.PI * 2;
                    dArray[2] = d17 - Math.PI * 2;
                    double[] dArray2 = dArray;
                    int n2 = dArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        double d19 = dArray2[i2];
                        double d20 = d15 - d13;
                        double d21 = d18 * d18 + d20 * d20;
                        double d22 = d21 <= 0.0 ? 0.0 : a.a((d19 * d18 + (d14 - d13) * d20) / d21, 0.0, 1.0);
                        double d23 = d22 * d18;
                        double d24 = d13 + d22 * d20;
                        double d25 = a.b(d24);
                        double d26 = a.c(d5, d25, d19 - d23);
                        if (!(d26 < d4)) continue;
                        return true;
                    }
                }
                d7 = d12;
                d8 = d16;
                d13 = d15;
            }
        }
        return false;
    }

    private static double sinDeltaBearing(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9 = Math.sin(d2);
        double d10 = Math.cos(d4);
        double d11 = Math.cos(d6);
        double d12 = d6 - d2;
        double d13 = d7 - d3;
        double d14 = d4 - d2;
        double d15 = d5 - d3;
        double d16 = Math.sin(d13) * d11;
        double d17 = Math.sin(d15) * d10;
        double d18 = Math.sin(d12) + 2.0 * d9 * d11 * a.c(d13);
        double d19 = (d16 * d16 + d18 * d18) * (d17 * d17 + (d8 = Math.sin(d14) + 2.0 * d9 * d10 * a.c(d15)) * d8);
        return d19 <= 0.0 ? 1.0 : (d16 * d8 - d18 * d17) / Math.sqrt(d19);
    }

    private static boolean isOnSegmentGC(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = a.c(d2, d6, d3 - d7);
        if (d9 <= d8) {
            return true;
        }
        double d10 = a.c(d4, d6, d5 - d7);
        if (d10 <= d8) {
            return true;
        }
        double d11 = MaptexPolyUtil.sinDeltaBearing(d2, d3, d4, d5, d6, d7);
        double d12 = a.e(d9);
        double d13 = a.f(d12 * d11);
        if (d13 > d8) {
            return false;
        }
        double d14 = a.c(d2, d4, d3 - d5);
        double d15 = d14 + d13 * (1.0 - 2.0 * d14);
        if (d9 <= d15 && d10 <= d15) {
            if (d14 < 0.74) {
                return true;
            }
            double d16 = 1.0 - 2.0 * d13;
            double d17 = (d9 - d13) / d16;
            double d18 = (d10 - d13) / d16;
            double d19 = a.b(d17, d18);
            return d19 > 0.0;
        }
        return false;
    }

    public static List<MaptexLatLng> simplify(List<MaptexLatLng> list, double d2) {
        Object object;
        Object object2;
        int n = list.size();
        if (n < 1) {
            throw new IllegalArgumentException("Polyline must have at least 1 point");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Tolerance must be greater than zero");
        }
        boolean bl = MaptexPolyUtil.isClosedPolygon(list);
        MaptexLatLng maptexLatLng = null;
        if (bl) {
            double d3 = 1.0E-11;
            maptexLatLng = list.get(list.size() - 1);
            list.remove(list.size() - 1);
            list.add(new MaptexLatLng(maptexLatLng.latitude + 1.0E-11, maptexLatLng.longitude + 1.0E-11));
        }
        int n2 = 0;
        Stack<Object> stack = new Stack<Object>();
        double[] dArray = new double[n];
        dArray[0] = 1.0;
        dArray[n - 1] = 1.0;
        double d4 = 0.0;
        if (n > 2) {
            object2 = new int[]{0, n - 1};
            stack.push(object2);
            while (stack.size() > 0) {
                Object object3 = (int[])stack.pop();
                double d5 = 0.0;
                for (object = (Object)(object3[0] + true); object < object3[1]; ++object) {
                    d4 = MaptexPolyUtil.distanceToLine(list.get((int)object), list.get((int)object3[0]), list.get((int)object3[1]));
                    if (!(d4 > d5)) continue;
                    d5 = d4;
                    n2 = object;
                }
                if (!(d5 > d2)) continue;
                dArray[n2] = d5;
                int[] nArray = new int[]{(int)object3[0], n2};
                stack.push(nArray);
                int[] nArray2 = new int[]{n2, (int)object3[1]};
                stack.push(nArray2);
            }
        }
        if (bl) {
            list.remove(list.size() - 1);
            list.add(maptexLatLng);
        }
        object = 0;
        object2 = new ArrayList();
        for (MaptexLatLng maptexLatLng2 : list) {
            if (dArray[object] != 0.0) {
                ((ArrayList)object2).add(maptexLatLng2);
            }
            ++object;
        }
        return object2;
    }

    public static boolean isClosedPolygon(List<MaptexLatLng> list) {
        MaptexLatLng maptexLatLng = list.get(0);
        MaptexLatLng maptexLatLng2 = list.get(list.size() - 1);
        return maptexLatLng.equals(maptexLatLng2);
    }

    public static double distanceToLine(MaptexLatLng maptexLatLng, MaptexLatLng maptexLatLng2, MaptexLatLng maptexLatLng3) {
        double d2;
        double d3;
        if (maptexLatLng2.equals(maptexLatLng3)) {
            return MaptexSphericalUtil.computeDistanceBetween(maptexLatLng3, maptexLatLng);
        }
        double d4 = Math.toRadians(maptexLatLng.latitude);
        double d5 = Math.toRadians(maptexLatLng.longitude);
        double d6 = Math.toRadians(maptexLatLng2.latitude);
        double d7 = Math.toRadians(maptexLatLng2.longitude);
        double d8 = Math.toRadians(maptexLatLng3.latitude);
        double d9 = d8 - d6;
        double d10 = ((d4 - d6) * d9 + (d5 - d7) * (d3 = (d2 = Math.toRadians(maptexLatLng3.longitude)) - d7)) / (d9 * d9 + d3 * d3);
        if (d10 <= 0.0) {
            return MaptexSphericalUtil.computeDistanceBetween(maptexLatLng, maptexLatLng2);
        }
        if (d10 >= 1.0) {
            return MaptexSphericalUtil.computeDistanceBetween(maptexLatLng, maptexLatLng3);
        }
        MaptexLatLng maptexLatLng4 = new MaptexLatLng(maptexLatLng.latitude - maptexLatLng2.latitude, maptexLatLng.longitude - maptexLatLng2.longitude);
        MaptexLatLng maptexLatLng5 = new MaptexLatLng(d10 * (maptexLatLng3.latitude - maptexLatLng2.latitude), d10 * (maptexLatLng3.longitude - maptexLatLng2.longitude));
        return MaptexSphericalUtil.computeDistanceBetween(maptexLatLng4, maptexLatLng5);
    }

    public static List<MaptexLatLng> decode(String string) {
        int n = string.length();
        ArrayList<MaptexLatLng> arrayList = new ArrayList<MaptexLatLng>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < n) {
            int n5;
            int n6 = 1;
            int n7 = 0;
            do {
                n5 = string.charAt(n2++) - 63 - 1;
                n6 += n5 << n7;
                n7 += 5;
            } while (n5 >= 31);
            n3 += (n6 & 1) != 0 ? ~(n6 >> 1) : n6 >> 1;
            n6 = 1;
            n7 = 0;
            do {
                n5 = string.charAt(n2++) - 63 - 1;
                n6 += n5 << n7;
                n7 += 5;
            } while (n5 >= 31);
            arrayList.add(new MaptexLatLng((double)n3 * 1.0E-5, (double)(n4 += (n6 & 1) != 0 ? ~(n6 >> 1) : n6 >> 1) * 1.0E-5));
        }
        return arrayList;
    }

    public static String encode(List<MaptexLatLng> list) {
        long l2 = 0L;
        long l3 = 0L;
        StringBuffer stringBuffer = new StringBuffer();
        for (MaptexLatLng maptexLatLng : list) {
            long l4 = Math.round(maptexLatLng.latitude * 100000.0);
            long l5 = Math.round(maptexLatLng.longitude * 100000.0);
            long l6 = l4 - l2;
            long l7 = l5 - l3;
            MaptexPolyUtil.encode(l6, stringBuffer);
            MaptexPolyUtil.encode(l7, stringBuffer);
            l2 = l4;
            l3 = l5;
        }
        return stringBuffer.toString();
    }

    private static void encode(long l2, StringBuffer stringBuffer) {
        long l3 = l2 = l2 < 0L ? l2 << 1 ^ 0xFFFFFFFFFFFFFFFFL : l2 << 1;
        while (l2 >= 32L) {
            stringBuffer.append(Character.toChars((int)((0x20L | l2 & 0x1FL) + 63L)));
            l2 >>= 5;
        }
        stringBuffer.append(Character.toChars((int)(l2 + 63L)));
    }
}

