package ir.map.sdk_map.wrapper;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;


public final class MaptexVisibleRegion implements Parcelable {

    public static final Creator<MaptexVisibleRegion> CREATOR = new Creator<MaptexVisibleRegion>() {
        public MaptexVisibleRegion createFromParcel(Parcel in) {
            return new MaptexVisibleRegion((com.google.android.gms.maps.model.VisibleRegion) in.readParcelable(null));
        }

        public MaptexVisibleRegion[] newArray(int size) {
            return new MaptexVisibleRegion[size];
        }
    };
    public final MaptexLatLng nearLeft;
    public final MaptexLatLng nearRight;
    public final MaptexLatLng farLeft;
    public final MaptexLatLng farRight;
    public final MaptexLatLngBounds maptexLatLngBounds;
    final com.google.android.gms.maps.model.VisibleRegion mOriginal;

    public MaptexVisibleRegion(MaptexLatLng nearLeft, MaptexLatLng nearRight, MaptexLatLng farLeft, MaptexLatLng farRight, MaptexLatLngBounds maptexLatLngBounds) {
        this(new com.google.android.gms.maps.model.VisibleRegion(new LatLng(nearLeft.latitude, nearLeft.longitude),
                new LatLng(nearRight.latitude, nearRight.longitude), new LatLng(farLeft.latitude, farLeft.longitude),
                new LatLng(farRight.latitude, farRight.longitude), maptexLatLngBounds.mOriginal));
    }

    private MaptexVisibleRegion(com.google.android.gms.maps.model.VisibleRegion original) {
        mOriginal = original;

        this.nearLeft = new MaptexLatLng(original.nearLeft.latitude, original.nearLeft.longitude);
        this.nearRight = new MaptexLatLng(original.nearRight.latitude, original.nearRight.longitude);
        this.farLeft = new MaptexLatLng(original.farLeft.latitude, original.farLeft.longitude);
        this.farRight = new MaptexLatLng(original.farRight.latitude, original.farRight.longitude);
        this.maptexLatLngBounds = MaptexLatLngBounds.obtain(original.latLngBounds);
    }

    /**
     * Obtain a new MaptexVisibleRegion based an original one.
     *
     * @param original
     * @return

     */
    public static MaptexVisibleRegion obtain(com.google.android.gms.maps.model.VisibleRegion original) {
        return new MaptexVisibleRegion(original);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaptexVisibleRegion)) {
            return false;
        }
        return mOriginal.equals(((MaptexVisibleRegion) other).mOriginal);
    }

    @Override
    public int hashCode() {
        return mOriginal.hashCode();
    }

    @Override
    public String toString() {
        return mOriginal.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(mOriginal, flags);
    }

}
