package ir.map.sdk_map.wrapper;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.android.gms.maps.model.LatLng;

import java.util.List;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.internal.ListTranslators;
import ir.map.sdk_map.internal.ListWrappers;


public final class MaptexPolylineOptions implements Parcelable {

    public static final Creator<MaptexPolylineOptions> CREATOR = new Creator<MaptexPolylineOptions>() {
        public MaptexPolylineOptions createFromParcel(Parcel in) {
            return new MaptexPolylineOptions((com.google.android.gms.maps.model.PolylineOptions) in.readParcelable(null));
        }

        public MaptexPolylineOptions[] newArray(int size) {
            return new MaptexPolylineOptions[size];
        }
    };

    /**
     * DO NOT USE. The original MaptexPolylineOptions.
     *

     */
    public final com.google.android.gms.maps.model.PolylineOptions mOriginal;

    private MaptexPolylineOptions mDefaultOptions;

    public MaptexPolylineOptions() {
        this(new com.google.android.gms.maps.model.PolylineOptions());
    }

    MaptexPolylineOptions(com.google.android.gms.maps.model.PolylineOptions original) {
        mOriginal = original;
    }

    @Override
    public int describeContents() {
        return mOriginal.describeContents();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        mOriginal.writeToParcel(out, flags);
    }

    public MaptexPolylineOptions add(MaptexLatLng point) {
        mOriginal.add(new LatLng(point.latitude, point.longitude));
        return this;
    }

    public MaptexPolylineOptions add(MaptexLatLng... points) {
        mOriginal.add(points == null ? null : ListTranslators.latLngs(points));
        return this;
    }

    public MaptexPolylineOptions addAll(Iterable<MaptexLatLng> points) {
        mOriginal.addAll(points == null ? null : ListTranslators.latLngList(points));
        return this;
    }

    public MaptexPolylineOptions color(int color) {
        mOriginal.color(color);
        return this;
    }

    public int getColor() {
        return mOriginal.getColor();
    }

    public List<MaptexLatLng> getPoints() {
        final List<com.google.android.gms.maps.model.LatLng> originals = mOriginal.getPoints();
        return originals == null ? null : ListWrappers.forLatLng(originals);
    }

    public float getWidth() {
        return mOriginal.getWidth();
    }

    public float getZIndex() {
        return mOriginal.getZIndex();
    }

    public MaptexPolylineOptions geodesic(boolean geodesic) {
        mOriginal.geodesic(geodesic);
        return this;
    }

    public boolean isGeodesic() {
        return mOriginal.isGeodesic();
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    /**
     * Reset the MaptexPolylineOptions by setting all of its properties to their default values.
     */
    @Maptex
    public void reset() {
        if (mDefaultOptions == null) {
            mDefaultOptions = new MaptexPolylineOptions();
        }
        color(mDefaultOptions.getColor());
        geodesic(mDefaultOptions.isGeodesic());
        visible(mDefaultOptions.isVisible());
        width(mDefaultOptions.getWidth());
        zIndex(mDefaultOptions.getZIndex());
        // HACK Cyril: The following line implies getPoints() returns the internal
        // list of points instead of a copy ... actually there's no guarantee of it.
        mOriginal.getPoints().clear();
    }

    public MaptexPolylineOptions visible(boolean visible) {
        mOriginal.visible(visible);
        return this;
    }

    public MaptexPolylineOptions width(float width) {
        mOriginal.width(width);
        return this;
    }

    public MaptexPolylineOptions zIndex(float zIndex) {
        mOriginal.zIndex(zIndex);
        return this;
    }

    public MaptexPolylineOptions clickable(boolean clickable) {
        mOriginal.clickable(clickable);
        return this;
    }

    public MaptexPolylineOptions jointType(int jointType) {
        mOriginal.jointType(jointType);
        return this;
    }

    public MaptexPolylineOptions startCap(MaptexRoundCap cap) {
        mOriginal.startCap(cap);
        return this;
    }

    public MaptexPolylineOptions endCap(MaptexRoundCap cap) {
        mOriginal.endCap(cap);
        return this;
    }

}
