package ir.map.sdk_map.wrapper;

import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;

public final class MaptexCircle {

    final com.google.android.gms.maps.model.Circle mOriginal;

    private MaptexCircle(com.google.android.gms.maps.model.Circle original) {
        mOriginal = original;
    }

    /**
     * <strong>DO NOT USE.</strong>

     * Obtain a new MaptexCircle based an original one.
     *
     * @param original
     * @return

     */
    public static MaptexCircle obtain(com.google.android.gms.maps.model.Circle original) {
        return new MaptexCircle(original);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaptexCircle)) {
            return false;
        }
        return mOriginal.equals(((MaptexCircle) other).mOriginal);
    }

    @Override
    public int hashCode() {
        return mOriginal.hashCode();
    }

    public MaptexLatLng getCenter() {
        final com.google.android.gms.maps.model.LatLng original = mOriginal.getCenter();
        return original == null ? null : new MaptexLatLng(original.latitude, original.longitude);
    }

    public void setCenter(MaptexLatLng center) {
        mOriginal.setCenter(center == null ? null : new LatLng(center.latitude, center.longitude));
    }

    public int getFillColor() {
        return mOriginal.getFillColor();
    }

    public void setFillColor(int fillColor) {
        mOriginal.setFillColor(fillColor);
    }

    public String getId() {
        return mOriginal.getId();
    }

    public double getRadius() {
        return mOriginal.getRadius();
    }

    public void setRadius(double radius) {
        mOriginal.setRadius(radius);
    }

    public int getStrokeColor() {
        return mOriginal.getStrokeColor();
    }

    public void setStrokeColor(int strokeColor) {
        mOriginal.setStrokeColor(strokeColor);
    }

    public float getStrokeWidth() {
        return mOriginal.getStrokeWidth();
    }

    public void setStrokeWidth(float strokeWidth) {
        mOriginal.setStrokeWidth(strokeWidth);
    }

    public float getZIndex() {
        return mOriginal.getZIndex();
    }

    public void setZIndex(float zIndex) {
        mOriginal.setZIndex(zIndex);
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    public void setVisible(boolean visible) {
        mOriginal.setVisible(visible);
    }

    public void remove() {
        mOriginal.remove();
    }

}
