/*
 * Decompiled with CFR 0.152.
 */
package io.vin.android.scanner.engine.impl;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import io.vin.android.scanner.Result;
import io.vin.android.scanner.engine.DecodeEngine;
import io.vin.android.scanner.util.DisplayUtils;
import io.vin.android.zbar.Image;
import io.vin.android.zbar.ImageScanner;
import io.vin.android.zbar.Symbol;
import io.vin.android.zbar.SymbolSet;
import io.vin.android.zbar.Symbology;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ZbarDecodeEngine
implements DecodeEngine {
    private final WeakReference<Context> mContext;
    private final WeakReference<View> mView;
    private ImageScanner mDecoder;
    private List<Symbology> mSymbologyList;
    private Rect mDecodeUIRect;

    public ZbarDecodeEngine(Context context, View view) {
        this.mContext = new WeakReference<Context>(context);
        this.mView = new WeakReference<View>(view);
        this.mDecoder = new ImageScanner();
        this.mSymbologyList = Symbology.ALL;
        this.configDecoder();
    }

    private void configDecoder() {
        this.mDecoder = new ImageScanner();
        this.mDecoder.setConfig(0, 256, 3);
        this.mDecoder.setConfig(0, 257, 3);
        this.mDecoder.setConfig(0, 0, 0);
        for (Symbology format : this.mSymbologyList) {
            this.mDecoder.setConfig(format.getId(), 0, 1);
        }
    }

    private Rect getScaledRect(Rect framingRect, int previewWidth, int previewHeight) {
        int height;
        int width;
        int scanerViewWidth = ((View)this.mView.get()).getWidth();
        int scanerViewHeight = ((View)this.mView.get()).getHeight();
        if (DisplayUtils.getScreenOrientation((Context)this.mContext.get()) == 1 && previewHeight < previewWidth) {
            width = previewHeight;
            height = previewWidth;
        } else if (DisplayUtils.getScreenOrientation((Context)this.mContext.get()) == 2 && previewHeight > previewWidth) {
            width = previewHeight;
            height = previewWidth;
        } else {
            width = previewWidth;
            height = previewHeight;
        }
        Rect scaledRect = new Rect(framingRect);
        scaledRect.left = scaledRect.left * width / scanerViewWidth;
        scaledRect.right = scaledRect.right * width / scanerViewWidth;
        scaledRect.top = scaledRect.top * height / scanerViewHeight;
        scaledRect.bottom = scaledRect.bottom * height / scanerViewHeight;
        return scaledRect;
    }

    private Rect getRotatedRect(Rect rect, int previewWidth, int previewHeight) {
        int orientation = this.getDisplayOrientation();
        Rect rotatedRect = new Rect(rect);
        if (orientation == 90) {
            rotatedRect.left = rect.top;
            rotatedRect.top = previewHeight - rect.right;
            rotatedRect.right = rect.bottom;
            rotatedRect.bottom = previewHeight - rect.left;
        } else if (orientation == 180) {
            rotatedRect.left = previewWidth - rect.right;
            rotatedRect.top = previewHeight - rect.bottom;
            rotatedRect.right = previewWidth - rect.left;
            rotatedRect.bottom = previewHeight - rect.top;
        } else if (orientation == 270) {
            rotatedRect.left = previewWidth - rect.bottom;
            rotatedRect.top = rect.left;
            rotatedRect.right = previewWidth - rect.top;
            rotatedRect.bottom = rect.right;
        }
        return rotatedRect;
    }

    public int getDisplayOrientation() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        int degrees = 0;
        switch (((WindowManager)((Context)this.mContext.get()).getSystemService("window")).getDefaultDisplay().getRotation()) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            return (360 - (info.orientation + degrees) % 360) % 360;
        }
        return (info.orientation - degrees + 360) % 360;
    }

    @Override
    public void enableCache(Boolean enable) {
        this.mDecoder.enableCache(true);
    }

    @Override
    public void setSymbology(List<Symbology> symbologyList) {
        this.mSymbologyList = symbologyList;
        this.configDecoder();
    }

    @Override
    public void setDecodeRect(Rect decodeRect) {
        this.mDecodeUIRect = decodeRect;
    }

    @Override
    public void setDecodeRect(View view) {
        Rect decodeArea = new Rect();
        Rect cropRect = new Rect();
        view.getGlobalVisibleRect(cropRect);
        Rect scanerRect = new Rect();
        ((View)this.mView.get()).getGlobalVisibleRect(scanerRect);
        decodeArea = cropRect;
        decodeArea.top = cropRect.top - scanerRect.top;
        decodeArea.bottom = cropRect.bottom - scanerRect.top;
        this.setDecodeRect(decodeArea);
    }

    @Override
    public List<Result> decode(byte[] data, Camera camera) {
        Camera.Size size = camera.getParameters().getPreviewSize();
        int width = size.width;
        int height = size.height;
        Image image = new Image(width, height, "Y800");
        image.setData(data);
        if (this.mDecodeUIRect != null) {
            Rect scaledRect = this.getScaledRect(this.mDecodeUIRect, width, height);
            Rect rotatedRect = this.getRotatedRect(scaledRect, width, height);
            image.setCrop(rotatedRect.left, rotatedRect.top, rotatedRect.width(), rotatedRect.height());
        }
        ArrayList<Result> resultList = new ArrayList<Result>();
        int result = this.mDecoder.scanImage(image);
        if (result != 0) {
            SymbolSet resultSet = this.mDecoder.getResults();
            for (Symbol symbolItem : resultSet) {
                if (TextUtils.isEmpty((CharSequence)symbolItem.getData())) continue;
                Result resultItem = new Result();
                resultItem.setContents(symbolItem.getData());
                resultItem.setSymbology(Symbology.getFormatById((int)symbolItem.getType()));
                resultList.add(resultItem);
            }
        }
        return resultList;
    }
}

