/*
 * Decompiled with CFR 0.152.
 */
package io.vin.android.scanner.core;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import io.vin.android.scanner.core.CameraPreview;
import io.vin.android.scanner.util.CameraUtils;

public abstract class CameraView
extends FrameLayout
implements Camera.PreviewCallback {
    private Camera mCamera;
    private CameraPreview mPreview;

    public CameraView(Context context) {
        super(context);
        this.setupLayout(context, null);
    }

    public CameraView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setupLayout(context, attributeSet);
    }

    public void setupLayout(Context context, AttributeSet attributeSet) {
        this.mPreview = new CameraPreview(context);
        this.addView((View)this.mPreview);
    }

    public void startCamera() {
        this.mCamera = CameraUtils.getCameraInstance();
        if (this.mCamera != null) {
            this.mPreview.setCamera(this.mCamera, this);
            this.mPreview.initCameraPreview();
        }
    }

    public void stopCamera() {
        if (this.mCamera != null) {
            this.mPreview.stopCameraPreview();
            this.mPreview.setCamera(null, null);
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFlash(boolean flag) {
        try {
            if (this.mCamera == null || !CameraUtils.isFlashSupported(this.mCamera)) return;
            Camera.Parameters parameters = this.mCamera.getParameters();
            if (flag) {
                if (parameters.getFlashMode().equals("torch")) return;
                parameters.setFlashMode("torch");
            } else {
                if (parameters.getFlashMode().equals("off")) return;
                parameters.setFlashMode("off");
            }
            this.mCamera.setParameters(parameters);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getFlash() {
        return this.mCamera != null && CameraUtils.isFlashSupported(this.mCamera) && this.mCamera.getParameters().getFlashMode().equals("torch");
    }

    public void toggleFlash() {
        if (this.mCamera != null && CameraUtils.isFlashSupported(this.mCamera)) {
            Camera.Parameters parameters = this.mCamera.getParameters();
            if (parameters.getFlashMode().equals("torch")) {
                parameters.setFlashMode("off");
            } else {
                parameters.setFlashMode("torch");
            }
            this.mCamera.setParameters(parameters);
        }
    }

    public void setAutoFocus(boolean state) {
        if (this.mPreview != null) {
            this.mPreview.setAutoFocus(state);
        }
    }

    public void setAutoFocusInterval(long millisecond) {
        if (this.mPreview != null) {
            this.mPreview.setAutoFocusInterval(millisecond);
        }
    }

    public int getDisplayOrientation() {
        return this.mPreview.getDisplayOrientation();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }
}

