/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl.types;

import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import java.math.BigInteger;

public final class NumberType
implements Response {
    private final Number value;

    public static NumberType create(Number value) {
        return new NumberType(value);
    }

    private NumberType(Number value) {
        this.value = value;
    }

    @Override
    public Number toNumber() {
        return this.value;
    }

    @Override
    public ResponseType type() {
        return ResponseType.NUMBER;
    }

    @Override
    public BigInteger toBigInteger() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        return BigInteger.valueOf(this.value.longValue());
    }

    @Override
    public Double toDouble() {
        return this.value.doubleValue();
    }

    @Override
    public Float toFloat() {
        return Float.valueOf(this.value.floatValue());
    }

    @Override
    public Long toLong() {
        return this.value.longValue();
    }

    @Override
    public Integer toInteger() {
        return this.value.intValue();
    }

    @Override
    public Short toShort() {
        return this.value.shortValue();
    }

    @Override
    public Byte toByte() {
        return this.value.byteValue();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public Boolean toBoolean() {
        return this.value.intValue() == 1;
    }
}

