/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl.types;

import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.client.impl.types.Multi;
import java.util.Iterator;

public final class PushType
implements Multi {
    private final Response[] replies;
    private int count;

    public static PushType create(long length) {
        return new PushType(new Response[(int)length]);
    }

    private PushType(Response[] replies) {
        this.replies = replies;
        this.count = 0;
    }

    @Override
    public ResponseType type() {
        return ResponseType.PUSH;
    }

    @Override
    public void add(Response reply) {
        this.replies[this.count++] = reply;
    }

    @Override
    public boolean complete() {
        return this.count == this.replies.length;
    }

    @Override
    public Response get(int index) {
        return this.replies[index];
    }

    @Override
    public int size() {
        return this.replies.length;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean more = false;
        for (Response r : this.replies) {
            if (more) {
                sb.append(", ");
            }
            if (r == null) {
                sb.append("null");
            } else {
                sb.append(r);
            }
            more = true;
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Iterator<Response> iterator() {
        return new Iterator<Response>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < PushType.this.replies.length;
            }

            @Override
            public Response next() {
                return PushType.this.replies[this.idx++];
            }
        };
    }
}

