/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.uri.PropertyName;
import io.trino.jdbc.NonRegisteringTrinoDriver;
import io.trino.jdbc.TrinoDriver;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class TrinoDataSource
implements DataSource {
    @GuardedBy(value="this")
    private String url;
    @GuardedBy(value="this")
    private PrintWriter printWriter;
    @GuardedBy(value="this")
    private final Properties connectionProperties = new Properties();
    private final Driver driver = new NonRegisteringTrinoDriver();

    @Override
    public synchronized Connection getConnection() throws SQLException {
        return this.driver.connect(this.url, this.connectionProperties);
    }

    @Override
    public synchronized Connection getConnection(String user, String password) throws SQLException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.connectionProperties);
        if (user != null) {
            properties.put(PropertyName.USER.toString(), user);
        }
        if (password != null) {
            properties.put(PropertyName.PASSWORD.toString(), password);
        }
        return this.driver.connect(this.url, properties);
    }

    @Override
    public synchronized PrintWriter getLogWriter() {
        return this.printWriter;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter out) {
        this.printWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        throw new UnsupportedOperationException("setLoginTimeout is not supported");
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger(TrinoDriver.class.getPackage().getName());
    }

    @.VisibleForTesting
    Driver getDriver() {
        return this.driver;
    }

    public synchronized DataSource setUrl(String url) {
        this.url = url;
        return this;
    }

    public synchronized String getUrl() {
        return this.url;
    }

    public synchronized Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public synchronized void setConnectionProperties(Properties properties) {
        this.connectionProperties.clear();
        this.connectionProperties.putAll((Map<?, ?>)properties);
    }

    public TrinoDataSource setUser(@.Nullable String user) {
        this.update(PropertyName.USER, user);
        return this;
    }

    public String getUser() {
        return this.get(PropertyName.USER);
    }

    public TrinoDataSource setPassword(@.Nullable String password) {
        this.update(PropertyName.PASSWORD, password);
        return this;
    }

    public String getPassword() {
        return this.get(PropertyName.PASSWORD);
    }

    public TrinoDataSource setCatalog(@.Nullable String catalog) {
        this.update(PropertyName.CATALOG, catalog);
        return this;
    }

    public String getCatalog() {
        return this.get(PropertyName.CATALOG);
    }

    public TrinoDataSource setSchema(@.Nullable String schema) {
        this.update(PropertyName.SCHEMA, schema);
        return this;
    }

    public String getSchema() {
        return this.get(PropertyName.CATALOG);
    }

    public TrinoDataSource setSessionUser(@.Nullable String sessionUser) {
        this.update(PropertyName.SESSION_USER, sessionUser);
        return this;
    }

    public String getSessionUser() {
        return this.get(PropertyName.SESSION_USER);
    }

    public TrinoDataSource setSqlPath(@.Nullable String sqlPath) {
        this.update(PropertyName.SQL_PATH, sqlPath);
        return this;
    }

    public String getSqlPath() {
        return this.get(PropertyName.SQL_PATH);
    }

    private synchronized void update(PropertyName key, String value) {
        if (value == null) {
            this.connectionProperties.remove((Object)key);
        } else {
            this.connectionProperties.setProperty(key.toString(), value);
        }
    }

    private synchronized String get(PropertyName key) {
        if (this.connectionProperties == null) {
            return null;
        }
        return this.connectionProperties.getProperty(key.toString());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw new SQLException(String.format("DataSource of type '%s' cannot be unwrapped to '%s'", this.getClass().getName(), iface.getName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }
}

