/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.guava.util.concurrent;

import com.google.errorprone.annotations.concurrent.LazyInit;
import io.trino.jdbc.;
import io.trino.jdbc.$internal.guava.annotations.GwtCompatible;
import io.trino.jdbc.$internal.guava.collect.ImmutableCollection;
import io.trino.jdbc.$internal.guava.collect.Lists;
import io.trino.jdbc.$internal.guava.util.concurrent.AggregateFuture;
import io.trino.jdbc.$internal.guava.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;

@GwtCompatible(emulated=true)
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    @LazyInit
    private @Nullable List<@Nullable Present<V>> values;

    CollectionFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
        super(futures, allMustSucceed, true);
        List<@Nullable T> values2 = futures.isEmpty() ? Collections.emptyList() : Lists.newArrayListWithCapacity(futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            values2.add(null);
        }
        this.values = values2;
    }

    @Override
    final void collectOneValue(int index, @.ParametricNullness V returnValue) {
        List<@Nullable Present<V>> localValues = this.values;
        if (localValues != null) {
            localValues.set(index, new Present<V>(returnValue));
        }
    }

    @Override
    final void handleAllCompleted() {
        List<@Nullable Present<V>> localValues = this.values;
        if (localValues != null) {
            this.set(this.combine(localValues));
        }
    }

    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
        super.releaseResources(reason);
        this.values = null;
    }

    abstract C combine(List<@Nullable Present<V>> var1);

    private static final class Present<V> {
        @.ParametricNullness
        final V value;

        Present(@.ParametricNullness V value) {
            this.value = value;
        }
    }

    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed);
            this.init();
        }

        @Override
        public List<@Nullable V> combine(List<@Nullable Present<V>> values2) {
            ArrayList<@Nullable Object> result = Lists.newArrayListWithCapacity(values2.size());
            for (Present<V> element : values2) {
                result.add(element != null ? (Object)element.value : null);
            }
            return Collections.unmodifiableList(result);
        }
    }
}

