/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.guava.util.concurrent;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.trino.jdbc.$internal.guava.annotations.GwtIncompatible;
import io.trino.jdbc.$internal.guava.annotations.J2ktIncompatible;
import io.trino.jdbc.$internal.guava.util.concurrent.AbstractService;
import io.trino.jdbc.$internal.guava.util.concurrent.MoreExecutors;
import io.trino.jdbc.$internal.guava.util.concurrent.Platform;
import io.trino.jdbc.$internal.guava.util.concurrent.Service;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@GwtIncompatible
@J2ktIncompatible
public abstract class AbstractExecutionThreadService
implements Service {
    private final Service delegate = new AbstractService(){

        @Override
        protected final void doStart() {
            Executor executor = MoreExecutors.renamingDecorator(AbstractExecutionThreadService.this.executor(), () -> AbstractExecutionThreadService.this.serviceName());
            executor.execute(() -> {
                try {
                    AbstractExecutionThreadService.this.startUp();
                    this.notifyStarted();
                    if (this.isRunning()) {
                        try {
                            AbstractExecutionThreadService.this.run();
                        }
                        catch (Throwable t) {
                            Platform.restoreInterruptIfIsInterruptedException(t);
                            try {
                                AbstractExecutionThreadService.this.shutDown();
                            }
                            catch (Exception ignored) {
                                Platform.restoreInterruptIfIsInterruptedException(ignored);
                                t.addSuppressed(ignored);
                            }
                            this.notifyFailed(t);
                            return;
                        }
                    }
                    AbstractExecutionThreadService.this.shutDown();
                    this.notifyStopped();
                }
                catch (Throwable t) {
                    Platform.restoreInterruptIfIsInterruptedException(t);
                    this.notifyFailed(t);
                }
            });
        }

        @Override
        protected void doStop() {
            AbstractExecutionThreadService.this.triggerShutdown();
        }

        @Override
        public String toString() {
            return AbstractExecutionThreadService.this.toString();
        }
    };

    protected AbstractExecutionThreadService() {
    }

    protected void startUp() throws Exception {
    }

    protected abstract void run() throws Exception;

    protected void shutDown() throws Exception {
    }

    protected void triggerShutdown() {
    }

    protected Executor executor() {
        return command -> MoreExecutors.newThread(this.serviceName(), command).start();
    }

    public String toString() {
        return this.serviceName() + " [" + (Object)((Object)this.state()) + "]";
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    @Override
    public final void addListener(Service.Listener listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    @Override
    public final Throwable failureCause() {
        return this.delegate.failureCause();
    }

    @Override
    @CanIgnoreReturnValue
    public final Service startAsync() {
        this.delegate.startAsync();
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final Service stopAsync() {
        this.delegate.stopAsync();
        return this;
    }

    @Override
    public final void awaitRunning() {
        this.delegate.awaitRunning();
    }

    @Override
    public final void awaitRunning(Duration timeout2) throws TimeoutException {
        Service.super.awaitRunning(timeout2);
    }

    @Override
    public final void awaitRunning(long timeout2, TimeUnit unit) throws TimeoutException {
        this.delegate.awaitRunning(timeout2, unit);
    }

    @Override
    public final void awaitTerminated() {
        this.delegate.awaitTerminated();
    }

    @Override
    public final void awaitTerminated(Duration timeout2) throws TimeoutException {
        Service.super.awaitTerminated(timeout2);
    }

    @Override
    public final void awaitTerminated(long timeout2, TimeUnit unit) throws TimeoutException {
        this.delegate.awaitTerminated(timeout2, unit);
    }

    protected String serviceName() {
        return this.getClass().getSimpleName();
    }
}

