/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.zstd;

import io.trino.jdbc.$internal.airlift.compress.v3.zstd.ZstdDecompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.ZstdNative;
import java.lang.foreign.MemorySegment;

public class ZstdNativeDecompressor
implements ZstdDecompressor {
    public ZstdNativeDecompressor() {
        ZstdNative.verifyEnabled();
    }

    public static boolean isEnabled() {
        return ZstdNative.isEnabled();
    }

    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        MemorySegment inputSegment = MemorySegment.ofArray(input).asSlice((long)inputOffset, inputLength);
        MemorySegment outputSegment = MemorySegment.ofArray(output).asSlice((long)outputOffset, maxOutputLength);
        return Math.toIntExact(ZstdNative.decompress(inputSegment, inputLength, outputSegment, maxOutputLength));
    }

    @Override
    public int decompress(MemorySegment input, MemorySegment output) {
        return Math.toIntExact(ZstdNative.decompress(input, input.byteSize(), output, output.byteSize()));
    }

    @Override
    public long getDecompressedSize(byte[] input, int offset, int length) {
        MemorySegment inputSegment = MemorySegment.ofArray(input).asSlice((long)offset, length);
        return ZstdNative.decompressedLength(inputSegment, length);
    }
}

