/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.zstd;

import io.trino.jdbc.$internal.airlift.compress.v3.zstd.ZstdCompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.ZstdNative;
import java.lang.foreign.MemorySegment;

public class ZstdNativeCompressor
implements ZstdCompressor {
    private final int compressionLevel;

    public ZstdNativeCompressor() {
        this(ZstdNative.DEFAULT_COMPRESSION_LEVEL);
    }

    public ZstdNativeCompressor(int compressionLevel) {
        ZstdNative.verifyEnabled();
        this.compressionLevel = compressionLevel;
    }

    public static boolean isEnabled() {
        return ZstdNative.isEnabled();
    }

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return Math.toIntExact(ZstdNative.maxCompressedLength(uncompressedSize));
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        MemorySegment inputSegment = MemorySegment.ofArray(input).asSlice((long)inputOffset, inputLength);
        MemorySegment outputSegment = MemorySegment.ofArray(output).asSlice((long)outputOffset, maxOutputLength);
        return Math.toIntExact(ZstdNative.compress(inputSegment, inputLength, outputSegment, maxOutputLength, this.compressionLevel));
    }

    @Override
    public int compress(MemorySegment input, MemorySegment output) {
        return Math.toIntExact(ZstdNative.compress(input, input.byteSize(), output, output.byteSize(), this.compressionLevel));
    }
}

