/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.ClientTypeSignature;
import io.trino.jdbc.$internal.client.ClientTypeSignatureParameter;
import io.trino.jdbc.$internal.client.Column;
import io.trino.jdbc.$internal.client.NamedClientTypeSignature;
import io.trino.jdbc.$internal.client.Row;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.$internal.guava.collect.Iterables;
import io.trino.jdbc.$internal.guava.collect.Maps;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class FixJsonDataUtils {
    private FixJsonDataUtils() {
    }

    public static Iterable<List<Object>> fixData(List<Column> columns, Iterable<List<Object>> data) {
        if (data == null) {
            return null;
        }
        ColumnTypeHandler[] typeHandlers = FixJsonDataUtils.createTypeHandlers(columns);
        return Iterables.transform(data, row -> FixJsonDataUtils.fixRow(typeHandlers, row));
    }

    private static List<Object> fixRow(ColumnTypeHandler[] typeHandlers, List<Object> row) {
        if (row.size() != typeHandlers.length) {
            throw new IllegalArgumentException("row/column size mismatch");
        }
        ArrayList<Object> newRow = new ArrayList<Object>(typeHandlers.length);
        int column = 0;
        for (Object value : row) {
            if (value != null) {
                value = typeHandlers[column].fixValue(value);
            }
            newRow.add(value);
            ++column;
        }
        return Collections.unmodifiableList(newRow);
    }

    private static ColumnTypeHandler[] createTypeHandlers(List<Column> columns) {
        Objects.requireNonNull(columns, "columns is null");
        ColumnTypeHandler[] typeHandlers = new ColumnTypeHandler[columns.size()];
        int index = 0;
        for (Column column : columns) {
            typeHandlers[index++] = FixJsonDataUtils.createTypeHandler(column.getTypeSignature());
        }
        return typeHandlers;
    }

    private static ColumnTypeHandler createTypeHandler(ClientTypeSignature signature) {
        switch (signature.getRawType()) {
            case "array": {
                return new ArrayClientTypeHandler(signature);
            }
            case "map": {
                return new MapClientTypeHandler(signature);
            }
            case "row": {
                return new RowClientTypeHandler(signature);
            }
            case "bigint": {
                return value -> {
                    if (value instanceof String) {
                        return Long.parseLong((String)value);
                    }
                    return ((Number)value).longValue();
                };
            }
            case "integer": {
                return value -> {
                    if (value instanceof String) {
                        return Integer.parseInt((String)value);
                    }
                    return ((Number)value).intValue();
                };
            }
            case "smallint": {
                return value -> {
                    if (value instanceof String) {
                        return Short.parseShort((String)value);
                    }
                    return ((Number)value).shortValue();
                };
            }
            case "tinyint": {
                return value -> {
                    if (value instanceof String) {
                        return Byte.parseByte((String)value);
                    }
                    return ((Number)value).byteValue();
                };
            }
            case "double": {
                return value -> {
                    if (value instanceof String) {
                        return Double.parseDouble((String)value);
                    }
                    return ((Number)value).doubleValue();
                };
            }
            case "real": {
                return value -> {
                    if (value instanceof String) {
                        return Float.valueOf(Float.parseFloat((String)value));
                    }
                    return Float.valueOf(((Number)value).floatValue());
                };
            }
            case "boolean": {
                return value -> {
                    if (value instanceof String) {
                        return Boolean.parseBoolean((String)value);
                    }
                    return (Boolean)value;
                };
            }
            case "varchar": 
            case "json": 
            case "time": 
            case "time with time zone": 
            case "timestamp": 
            case "timestamp with time zone": 
            case "date": 
            case "interval year to month": 
            case "interval day to second": 
            case "ipaddress": 
            case "uuid": 
            case "decimal": 
            case "char": 
            case "Geometry": 
            case "SphericalGeography": {
                return value -> (String)value;
            }
            case "BingTile": {
                return value -> value;
            }
        }
        return value -> {
            if (value instanceof String) {
                return Base64.getDecoder().decode((String)value);
            }
            return value;
        };
    }

    private static interface ColumnTypeHandler {
        public Object fixValue(Object var1);
    }

    private static final class ArrayClientTypeHandler
    implements ColumnTypeHandler {
        private final ColumnTypeHandler elementHandler;

        private ArrayClientTypeHandler(ClientTypeSignature signature) {
            Objects.requireNonNull(signature, "signature is null");
            Preconditions.checkArgument(signature.getRawType().equals("array"), "not an array type signature: %s", (Object)signature);
            this.elementHandler = FixJsonDataUtils.createTypeHandler(signature.getArgumentsAsTypeSignatures().get(0));
        }

        @Override
        public List<Object> fixValue(Object value) {
            List listValue = (List)value;
            ArrayList<Object> fixedValues = new ArrayList<Object>(listValue.size());
            for (Object element : listValue) {
                if (element != null) {
                    element = this.elementHandler.fixValue(element);
                }
                fixedValues.add(element);
            }
            return fixedValues;
        }
    }

    private static final class MapClientTypeHandler
    implements ColumnTypeHandler {
        private final ColumnTypeHandler keyHandler;
        private final ColumnTypeHandler valueHandler;

        private MapClientTypeHandler(ClientTypeSignature signature) {
            Objects.requireNonNull(signature, "signature is null");
            Preconditions.checkArgument(signature.getRawType().equals("map"), "not a map type signature: %s", (Object)signature);
            this.keyHandler = FixJsonDataUtils.createTypeHandler(signature.getArgumentsAsTypeSignatures().get(0));
            this.valueHandler = FixJsonDataUtils.createTypeHandler(signature.getArgumentsAsTypeSignatures().get(1));
        }

        @Override
        public Map<Object, Object> fixValue(Object value) {
            Map mapValue = (Map)value;
            HashMap<Object, Object> fixedMap = Maps.newHashMapWithExpectedSize(mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                Object fixedValue;
                Object fixedKey = entry.getKey();
                if (fixedKey != null) {
                    fixedKey = this.keyHandler.fixValue(fixedKey);
                }
                if ((fixedValue = entry.getValue()) != null) {
                    fixedValue = this.valueHandler.fixValue(fixedValue);
                }
                fixedMap.put(fixedKey, fixedValue);
            }
            return fixedMap;
        }
    }

    private static final class RowClientTypeHandler
    implements ColumnTypeHandler {
        private final ColumnTypeHandler[] fieldHandlers;
        private final List<Optional<String>> fieldNames;

        private RowClientTypeHandler(ClientTypeSignature signature) {
            Objects.requireNonNull(signature, "signature is null");
            Preconditions.checkArgument(signature.getRawType().equals("row"), "not a row type signature: %s", (Object)signature);
            this.fieldHandlers = new ColumnTypeHandler[signature.getArguments().size()];
            ImmutableList.Builder fieldNames = ImmutableList.builderWithExpectedSize(this.fieldHandlers.length);
            int index = 0;
            for (ClientTypeSignatureParameter parameter : signature.getArguments()) {
                Preconditions.checkArgument(parameter.getKind() == ClientTypeSignatureParameter.ParameterKind.NAMED_TYPE, "Unexpected parameter [%s] for row type", (Object)parameter);
                NamedClientTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                this.fieldHandlers[index] = FixJsonDataUtils.createTypeHandler(namedTypeSignature.getTypeSignature());
                fieldNames.add(namedTypeSignature.getName());
                ++index;
            }
            this.fieldNames = fieldNames.build();
        }

        @Override
        public Row fixValue(Object value) {
            List listValue = (List)value;
            Preconditions.checkArgument(listValue.size() == this.fieldHandlers.length, "Mismatched data values and row type");
            Row.Builder row = Row.builderWithExpectedSize(this.fieldHandlers.length);
            int field = 0;
            for (Object fieldValue : listValue) {
                if (fieldValue != null) {
                    fieldValue = this.fieldHandlers[field].fixValue(fieldValue);
                }
                row.addField(this.fieldNames.get(field), fieldValue);
                ++field;
            }
            return row.build();
        }
    }
}

