/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.trino.jdbc.\$internal.airlift.compress.lzo;

import io.trino.jdbc.\$internal.airlift.compress.hadoop.CodecAdapter;

import static io.trino.jdbc.\$internal.airlift.compress.lzo.LzoCodec.getBufferSize;

public class LzopCodec
        extends CodecAdapter
{
    public LzopCodec()
    {
        super(configuration -> new LzopHadoopStreams(getBufferSize(configuration)));
    }
}
