/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.semconv.network;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.semconv.network.internal.InternalServerAttributesExtractor;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.semconv.network.internal.ServerAddressAndPortExtractor;
import javax.annotation.Nullable;

/**
 * Extractor of <a
 * href="https://github.com/open-telemetry/semantic-conventions/blob/v1.23.0/docs/general/attributes.md#server-attributes">server
 * attributes</a>.
 *
 * @since 2.0.0
 */
public final class ServerAttributesExtractor<REQUEST, RESPONSE>
    implements AttributesExtractor<REQUEST, RESPONSE> {

  /**
   * Creates the server attributes extractor.
   *
   * @see InstrumenterBuilder#addAttributesExtractor(AttributesExtractor)
   */
  public static <REQUEST, RESPONSE> ServerAttributesExtractor<REQUEST, RESPONSE> create(
      ServerAttributesGetter<REQUEST> getter) {
    return new ServerAttributesExtractor<>(getter);
  }

  private final InternalServerAttributesExtractor<REQUEST> internalExtractor;

  ServerAttributesExtractor(ServerAttributesGetter<REQUEST> getter) {
    internalExtractor =
        new InternalServerAttributesExtractor<>(
            new ServerAddressAndPortExtractor<>(getter, AddressAndPortExtractor.noop()));
  }

  @Override
  public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    internalExtractor.onStart(attributes, request);
  }

  @Override
  public void onEnd(
      AttributesBuilder attributes,
      Context context,
      REQUEST request,
      @Nullable RESPONSE response,
      @Nullable Throwable error) {}
}
