/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.SemanticAttributes;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.SpanKey;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpCommonAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesExtractorBuilder;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpStatusCodeConverter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal.InternalClientAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal.InternalNetworkAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal.InternalServerAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.url.internal.InternalUrlAttributesExtractor;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HttpServerAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpServerAttributesGetter<REQUEST, RESPONSE>>
implements SpanKeyProvider {
    private final InternalUrlAttributesExtractor<REQUEST> internalUrlExtractor;
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final InternalServerAttributesExtractor<REQUEST> internalServerExtractor;
    private final InternalClientAttributesExtractor<REQUEST> internalClientExtractor;
    private final Function<Context, String> httpRouteGetter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return HttpServerAttributesExtractor.builder(httpAttributesGetter).build();
    }

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return new HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter);
    }

    HttpServerAttributesExtractor(HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder) {
        super(builder.httpAttributesGetter, HttpStatusCodeConverter.SERVER, builder.capturedRequestHeaders, builder.capturedResponseHeaders, builder.knownMethods);
        this.internalUrlExtractor = builder.buildUrlExtractor();
        this.internalNetworkExtractor = builder.buildNetworkExtractor();
        this.internalServerExtractor = builder.buildServerExtractor();
        this.internalClientExtractor = builder.buildClientExtractor();
        this.httpRouteGetter = builder.httpRouteGetter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        this.internalUrlExtractor.onStart(attributes, request);
        this.internalServerExtractor.onStart(attributes, request);
        this.internalClientExtractor.onStart(attributes, request);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_ROUTE, ((HttpServerAttributesGetter)this.getter).getHttpRoute(request));
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.USER_AGENT_ORIGINAL, this.userAgent(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        this.internalNetworkExtractor.onEnd(attributes, request, response);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_ROUTE, this.httpRouteGetter.apply(context));
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.HTTP_SERVER;
    }

    @Nullable
    private String userAgent(REQUEST request) {
        return HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).getHttpRequestHeader(request, "user-agent"));
    }
}

